/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.generator.impl;

import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.config.JavadocConfig;
import com.mybatisflex.codegen.config.PackageConfig;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.codegen.generator.IGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class PackageInfoGenerator
implements IGenerator {
    private String templatePath;

    public PackageInfoGenerator() {
        this("/templates/enjoy/package-info.tpl");
    }

    public PackageInfoGenerator(String templatePath) {
        this.templatePath = templatePath;
    }

    @Override
    public void generate(Table table, GlobalConfig globalConfig) {
        if (!globalConfig.isPackageInfoGenerateEnable()) {
            return;
        }
        JavadocConfig javadocConfig = globalConfig.getJavadocConfig();
        PackageConfig packageConfig = globalConfig.getPackageConfig();
        String sourceDir = packageConfig.getSourceDir();
        ArrayList<Data> dataList = new ArrayList<Data>();
        if (globalConfig.isEntityGenerateEnable()) {
            dataList.add(new Data(sourceDir, packageConfig.getEntityPackage(), javadocConfig.getEntityPackage()));
        }
        if (globalConfig.isMapperGenerateEnable()) {
            dataList.add(new Data(sourceDir, packageConfig.getMapperPackage(), javadocConfig.getMapperPackage()));
        }
        if (globalConfig.isServiceGenerateEnable()) {
            dataList.add(new Data(sourceDir, packageConfig.getServicePackage(), javadocConfig.getServicePackage()));
        }
        if (globalConfig.isServiceImplGenerateEnable()) {
            dataList.add(new Data(sourceDir, packageConfig.getServiceImplPackage(), javadocConfig.getServiceImplPackage()));
        }
        if (globalConfig.isControllerGenerateEnable()) {
            dataList.add(new Data(sourceDir, packageConfig.getControllerPackage(), javadocConfig.getControllerPackage()));
        }
        if (globalConfig.isTableDefGenerateEnable()) {
            dataList.add(new Data(sourceDir, packageConfig.getTableDefPackage(), javadocConfig.getTableDefPackage()));
        }
        dataList.forEach(data -> {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("packageName", data.packageName);
            params.put("packageComment", data.packageComment);
            params.put("javadocConfig", javadocConfig);
            globalConfig.getTemplateConfig().getTemplate().generate(params, this.templatePath, data.filePath);
        });
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    private static class Data {
        String packageName;
        String packageComment;
        File filePath;

        Data(String sourceDir, String packageName, String packageComment) {
            this.packageName = packageName;
            this.packageComment = packageComment;
            this.filePath = this.getFilePath(sourceDir, packageName);
        }

        File getFilePath(String sourceDir, String packageName) {
            return new File(sourceDir, packageName.replace(".", "/") + "/package-info.java");
        }
    }
}

