/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.injector;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mycila.inject.MycilaGuiceException;
import com.mycila.inject.injector.KeyProvider;
import com.mycila.inject.internal.Proxy;
import com.mycila.inject.internal.Reflect;
import com.mycila.inject.internal.guava.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public final class MemberInjectorTypeListener<A extends Annotation>
implements TypeListener {
    private final Class<A> annotationType;
    private final Class<? extends KeyProvider<A>> providerClass;

    public MemberInjectorTypeListener(Class<A> annotationType, Class<? extends KeyProvider<A>> providerClass) {
        this.annotationType = annotationType;
        this.providerClass = providerClass;
    }

    public <I> void hear(final TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
        final Provider provider = encounter.getProvider(this.providerClass);
        final Provider injectorProvider = encounter.getProvider(Injector.class);
        encounter.register(new MembersInjector<I>(){

            public void injectMembers(I injectee) {
                KeyProvider keyProvider = (KeyProvider)provider.get();
                for (Field field : Reflect.findFields(injectableType.getRawType(), Reflect.annotatedBy(MemberInjectorTypeListener.this.annotationType))) {
                    Object value = ((Injector)injectorProvider.get()).getProvider(keyProvider.getKey(injectableType, field, field.getAnnotation(MemberInjectorTypeListener.this.annotationType))).get();
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    try {
                        field.set(injectee, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Failed to inject field " + field + ". Reason: " + e.getMessage(), e);
                    }
                }
                for (Method method : Iterables.filter(Reflect.findMethods(injectableType.getRawType()), Reflect.annotatedBy(MemberInjectorTypeListener.this.annotationType))) {
                    List<Key<?>> parameterKeys = keyProvider.getParameterKeys(injectableType, method, method.getAnnotation(MemberInjectorTypeListener.this.annotationType));
                    Object[] parameters = new Object[parameterKeys.size()];
                    for (int i = 0; i < parameters.length; ++i) {
                        parameters[i] = ((Injector)injectorProvider.get()).getProvider(parameterKeys.get(i)).get();
                    }
                    try {
                        Proxy.invoker(method).invoke(injectee, parameters);
                    }
                    catch (Exception e) {
                        throw MycilaGuiceException.runtime(e);
                    }
                }
            }
        });
    }
}

