/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.collect;

import com.mycila.inject.internal.guava.base.Preconditions;
import com.mycila.inject.internal.guava.collect.ImmutableAsList;
import com.mycila.inject.internal.guava.collect.ImmutableList;
import com.mycila.inject.internal.guava.collect.ImmutableSortedSet;
import com.mycila.inject.internal.guava.collect.RegularImmutableSortedSet;
import com.mycila.inject.internal.guava.collect.UnmodifiableIterator;
import com.mycila.inject.internal.guava.collect.UnmodifiableListIterator;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableSortedAsList<E>
extends ImmutableList<E> {
    private final transient ImmutableSortedSet<E> backingSet;
    private final transient ImmutableList<E> backingList;

    ImmutableSortedAsList(ImmutableSortedSet<E> backingSet, ImmutableList<E> backingList) {
        this.backingSet = backingSet;
        this.backingList = backingList;
    }

    @Override
    public boolean contains(Object target) {
        return this.backingSet.indexOf(target) >= 0;
    }

    @Override
    public int indexOf(Object target) {
        return this.backingSet.indexOf(target);
    }

    @Override
    public int lastIndexOf(Object target) {
        return this.backingSet.indexOf(target);
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
        return fromIndex == toIndex ? ImmutableList.of() : new RegularImmutableSortedSet<E>(this.backingList.subList(fromIndex, toIndex), this.backingSet.comparator()).asList();
    }

    @Override
    Object writeReplace() {
        return new ImmutableAsList.SerializedForm(this.backingSet);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.backingList.iterator();
    }

    @Override
    public E get(int index) {
        return this.backingList.get(index);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.backingList.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.backingList.listIterator(index);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this.backingList.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.backingList.hashCode();
    }

    @Override
    boolean isPartialView() {
        return this.backingList.isPartialView();
    }
}

