/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.collect;

import com.mycila.inject.internal.guava.annotations.GwtCompatible;
import com.mycila.inject.internal.guava.base.Preconditions;
import com.mycila.inject.internal.guava.collect.Lists;
import com.mycila.inject.internal.guava.collect.Ordering;
import com.mycila.inject.internal.guava.collect.ReverseNaturalOrdering;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class NaturalOrdering
extends Ordering<Comparable>
implements Serializable {
    static final NaturalOrdering INSTANCE = new NaturalOrdering();
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable left, Comparable right) {
        Preconditions.checkNotNull(right);
        if (left == right) {
            return 0;
        }
        int result = left.compareTo(right);
        return result;
    }

    @Override
    public <S extends Comparable> Ordering<S> reverse() {
        return ReverseNaturalOrdering.INSTANCE;
    }

    @Override
    public int binarySearch(List<? extends Comparable> sortedList, Comparable key) {
        return Collections.binarySearch(sortedList, key);
    }

    @Override
    public <E extends Comparable> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> list = Lists.newArrayList(iterable);
        Collections.sort(list);
        return list;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Ordering.natural()";
    }

    private NaturalOrdering() {
    }
}

