/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.collect;

import com.mycila.inject.internal.guava.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SortedLists {
    private SortedLists() {
    }

    public static <E> int binarySearch(List<? extends E> list, @Nullable E e, Comparator<? super E> comparator, Relation relation) {
        return SortedLists.binarySearch(list, e, comparator, relation, true);
    }

    static <E> int binarySearch(List<? extends E> list, @Nullable E e, Comparator<? super E> comparator, Relation relation, boolean worryAboutDuplicates) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(relation);
        int lower = 0;
        int upper = list.size() - 1;
        while (lower <= upper) {
            int middle = lower + (upper - lower) / 2;
            int c = comparator.compare(e, list.get(middle));
            if (c < 0) {
                upper = middle - 1;
                continue;
            }
            if (c > 0) {
                lower = middle + 1;
                continue;
            }
            return relation.exactMatchFound(list, e, lower, middle, upper, comparator, worryAboutDuplicates);
        }
        return relation.exactMatchNotFound(list, e, lower, comparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Relation {
        LOWER{

            @Override
            public Relation reverse() {
                return HIGHER;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int lower, int index, int upper, Comparator<? super E> comparator, boolean worryAboutDuplicates) {
                return FLOOR.exactMatchFound(list, e, lower, index, upper, comparator, worryAboutDuplicates) - 1;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int higherIndex, Comparator<? super E> comparator) {
                return higherIndex - 1;
            }
        }
        ,
        FLOOR{

            @Override
            public Relation reverse() {
                return CEILING;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int lower, int index, int upper, Comparator<? super E> comparator, boolean worryAboutDuplicates) {
                if (!worryAboutDuplicates) {
                    return index;
                }
                upper = index;
                while (lower < upper) {
                    int middle = lower + (upper - lower) / 2;
                    int c = comparator.compare(list.get(middle), e);
                    if (c < 0) {
                        lower = middle + 1;
                        continue;
                    }
                    upper = middle;
                }
                return lower;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int higherIndex, Comparator<? super E> comparator) {
                return higherIndex - 1;
            }
        }
        ,
        EQUAL{

            @Override
            public Relation reverse() {
                return this;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int lower, int index, int upper, Comparator<? super E> comparator, boolean worryAboutDuplicates) {
                return index;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int higherIndex, Comparator<? super E> comparator) {
                return -1;
            }
        }
        ,
        CEILING{

            @Override
            public Relation reverse() {
                return FLOOR;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int lower, int index, int upper, Comparator<? super E> comparator, boolean worryAboutDuplicates) {
                if (!worryAboutDuplicates) {
                    return index;
                }
                lower = index;
                while (lower < upper) {
                    int middle = lower + (upper - lower + 1) / 2;
                    int c = comparator.compare(list.get(middle), e);
                    if (c > 0) {
                        upper = middle - 1;
                        continue;
                    }
                    lower = middle;
                }
                return lower;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int higherIndex, Comparator<? super E> comparator) {
                return higherIndex;
            }
        }
        ,
        HIGHER{

            @Override
            public Relation reverse() {
                return LOWER;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int lower, int index, int upper, Comparator<? super E> comparator, boolean worryAboutDuplicates) {
                return CEILING.exactMatchFound(list, e, lower, index, upper, comparator, worryAboutDuplicates) + 1;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int higherIndex, Comparator<? super E> comparator) {
                return higherIndex;
            }
        };


        public abstract Relation reverse();

        abstract <E> int exactMatchFound(List<? extends E> var1, @Nullable E var2, int var3, int var4, int var5, Comparator<? super E> var6, boolean var7);

        abstract <E> int exactMatchNotFound(List<? extends E> var1, @Nullable E var2, int var3, Comparator<? super E> var4);
    }
}

