/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.util.concurrent;

import com.mycila.inject.internal.guava.annotations.Beta;
import com.mycila.inject.internal.guava.util.concurrent.CheckedFuture;
import com.mycila.inject.internal.guava.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractCheckedFuture<V, X extends Exception>
implements CheckedFuture<V, X> {
    protected final ListenableFuture<V> delegate;

    protected AbstractCheckedFuture(ListenableFuture<V> delegate) {
        this.delegate = delegate;
    }

    protected abstract X mapException(Exception var1);

    @Override
    public V checkedGet() throws X {
        try {
            return this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.mapException(e);
        }
        catch (CancellationException e) {
            throw this.mapException(e);
        }
        catch (ExecutionException e) {
            throw this.mapException(e);
        }
    }

    @Override
    public V checkedGet(long timeout, TimeUnit unit) throws TimeoutException, X {
        try {
            return this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.mapException(e);
        }
        catch (CancellationException e) {
            throw this.mapException(e);
        }
        catch (ExecutionException e) {
            throw this.mapException(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @Override
    public void addListener(Runnable listener, Executor exec) {
        this.delegate.addListener(listener, exec);
    }
}

