/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.jsr250;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.mycila.inject.internal.Reflect;
import com.mycila.inject.internal.guava.collect.Iterables;
import com.mycila.inject.jsr250.Jsr250Destroyer;
import com.mycila.inject.jsr250.Jsr250Injector;
import com.mycila.inject.jsr250.Jsr250Module;
import com.mycila.inject.jsr250.Jsr250PreDestroyHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.PreDestroy;

public final class Jsr250 {
    private Jsr250() {
    }

    public static Jsr250Injector createInjector(Module ... modules) {
        return Jsr250.createInjector(Arrays.asList(modules));
    }

    public static Jsr250Injector createInjector(Iterable<? extends Module> modules) {
        return Jsr250.createInjector(Stage.DEVELOPMENT, modules);
    }

    public static Jsr250Injector createInjector(Stage stage, Module ... modules) {
        return Jsr250.createInjector(stage, Arrays.asList(modules));
    }

    public static Jsr250Injector createInjector(Stage stage, Iterable<? extends Module> modules) {
        return (Jsr250Injector)Guice.createInjector((Stage)stage, Jsr250.hasJSR250Module(stage, modules) ? modules : Iterables.concat(modules, Arrays.asList(new Jsr250Module()))).getInstance(Jsr250Injector.class);
    }

    private static boolean hasJSR250Module(Stage stage, Iterable<? extends Module> modules) {
        final Key key = Key.get(Jsr250Destroyer.class);
        for (Element element : Elements.getElements((Stage)stage, modules)) {
            Boolean res = (Boolean)element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Boolean>(){

                public <T> Boolean visit(Binding<T> binding) {
                    return key.equals((Object)binding.getKey());
                }
            });
            if (res == null || !res.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Module newJsr250Module() {
        return new Jsr250Module();
    }

    public static boolean hasJSR250Module(Injector injector) {
        return injector.getBindings().containsKey(Key.get(Jsr250Destroyer.class));
    }

    public static <T> void preDestroy(T instance) {
        TypeLiteral type = TypeLiteral.get(Reflect.getTargetClass(instance));
        Jsr250PreDestroyHandler handler = new Jsr250PreDestroyHandler();
        for (Method method : Iterables.filter(Reflect.findMethods(type.getRawType()), Reflect.annotatedBy(PreDestroy.class))) {
            handler.handle(type, instance, method, method.getAnnotation(PreDestroy.class));
        }
    }
}

