/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.jsr250;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.spi.BindingScopingVisitor;
import com.mycila.inject.MycilaGuice;
import com.mycila.inject.annotation.Jsr250Singleton;
import com.mycila.inject.jsr250.Jsr250;
import com.mycila.inject.jsr250.Jsr250Destroyer;
import com.mycila.inject.jsr250.Jsr250Injector;
import com.mycila.inject.jsr250.Jsr250InjectorImpl;
import com.mycila.inject.jsr250.Jsr250KeyProvider;
import com.mycila.inject.jsr250.Jsr250PostConstructHandler;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

final class Jsr250Module
implements Module {
    private final Set<Scope> scopes = new HashSet<Scope>();
    private final Set<Class<? extends Annotation>> scopeAnnotations = new HashSet<Class<? extends Annotation>>();

    Jsr250Module() {
    }

    public void configure(Binder binder) {
        binder.bind(Jsr250Injector.class).to(Jsr250InjectorImpl.class).in(Singleton.class);
        MycilaGuice.in(binder).bindAnnotationInjector(Resource.class, Jsr250KeyProvider.class).handleMethodAfterInjection(PostConstruct.class, Jsr250PostConstructHandler.class).bind(Jsr250Destroyer.class, new Jsr250Destroyer(){
            @Inject
            Injector injector;

            @Override
            public void preDestroy() {
                BindingScopingVisitor<Boolean> visitor = new BindingScopingVisitor<Boolean>(){

                    public Boolean visitEagerSingleton() {
                        return true;
                    }

                    public Boolean visitScope(Scope scope) {
                        return scope.getClass().isAnnotationPresent(Jsr250Singleton.class) || Jsr250Module.this.scopes.contains(scope);
                    }

                    public Boolean visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
                        return scopeAnnotation.isAnnotationPresent(Jsr250Singleton.class) || Jsr250Module.this.scopeAnnotations.contains(scopeAnnotation);
                    }

                    public Boolean visitNoScoping() {
                        return false;
                    }
                };
                for (Binding binding : this.injector.getAllBindings().values()) {
                    if (!Scopes.isSingleton((Binding)binding) && !((Boolean)binding.acceptScopingVisitor((BindingScopingVisitor)visitor)).booleanValue()) continue;
                    Jsr250.preDestroy(binding.getProvider().get());
                }
                for (Scope scope : this.injector.getScopeBindings().values()) {
                    Jsr250.preDestroy(scope);
                }
            }
        });
    }

    public Jsr250Module addCloseableScopes(Scope ... scopes) {
        this.scopes.addAll(Arrays.asList(scopes));
        return this;
    }

    public Jsr250Module addCloseableScopes(Class<? extends Annotation> ... scopeAnnotations) {
        this.scopeAnnotations.addAll(Arrays.asList(scopeAnnotations));
        return this;
    }
}

