/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.legacy;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.mycila.inject.MycilaGuiceException;
import com.mycila.inject.internal.Proxy;
import com.mycila.inject.internal.Reflect;
import com.mycila.inject.internal.guava.base.Predicates;
import com.mycila.inject.internal.guava.collect.Iterators;
import com.mycila.inject.internal.guava.collect.UnmodifiableIterator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class LegacyProvider<T>
implements Provider<T> {
    @Inject
    Injector fromGuice;
    final Key<?>[] parametersTypes;
    final Class<T> providedType;

    private LegacyProvider(Class<T> providedType, Key<?> ... parametersTypes) {
        this.parametersTypes = parametersTypes;
        this.providedType = providedType;
    }

    public LegacyProvider<T> inject(String methodName, Class<?> ... paramTypes) {
        return this.inject(methodName, LegacyProvider.toKeys(paramTypes));
    }

    public LegacyProvider<T> inject(String methodName, Key<?> ... paramKeys) {
        return new MethodLegacyProvider<T>(this, this.providedType, methodName, paramKeys);
    }

    final Object[] getParameterValues(Injector injector) {
        Object[] values = new Object[this.parametersTypes.length];
        int i = 0;
        for (Key<?> key : this.parametersTypes) {
            values[i++] = injector.getInstance(key);
        }
        return values;
    }

    public final T get() {
        return this.get(this.fromGuice);
    }

    abstract T get(Injector var1);

    public String toString() {
        return "LegacyProvider[" + this.providedType.getName() + "]";
    }

    public static <T> ConstructBuilder<T> of(Class<T> type) {
        return new ConstructBuilder(type);
    }

    private static Class<?>[] toClasses(Key<?> ... keys) {
        Class[] types = new Class[keys.length];
        int i = 0;
        for (Key<?> key : keys) {
            types[i++] = (Class)key.getTypeLiteral().getType();
        }
        return types;
    }

    private static Key<?>[] toKeys(Class<?> ... classes) {
        Key[] types = new Key[classes.length];
        int i = 0;
        for (Class<?> c : classes) {
            types[i++] = Key.get(c);
        }
        return types;
    }

    private static Method findMethod(Class<?> declaring, String methodName, Key<?> ... paramTypes) {
        try {
            return declaring.getMethod(methodName, LegacyProvider.toClasses(paramTypes));
        }
        catch (NoSuchMethodException e) {
            UnmodifiableIterator<Method> methods = Iterators.filter(Reflect.findMethods(declaring).iterator(), Predicates.and(Reflect.named(methodName), Reflect.withParameterTypes(LegacyProvider.toClasses(paramTypes))));
            if (!methods.hasNext()) {
                throw MycilaGuiceException.exception("Unable to find method " + methodName + " in class " + declaring.getName() + " matching given parameter types", e);
            }
            return (Method)methods.next();
        }
    }

    private static class MethodLegacyProvider<T>
    extends LegacyProvider<T> {
        private final LegacyProvider<T> instance;
        private final Method method;

        MethodLegacyProvider(LegacyProvider<T> instance, Class<T> providedType, String methodName, Key<?> ... paramTypes) {
            super((Class)providedType, (Key[])paramTypes);
            this.instance = instance;
            this.method = LegacyProvider.findMethod(providedType, methodName, paramTypes);
        }

        @Override
        public T get(Injector injector) {
            T target = this.instance.get(injector);
            try {
                Proxy.invoker(this.method).invoke(target, this.getParameterValues(injector));
                return target;
            }
            catch (Exception e) {
                throw MycilaGuiceException.runtime(e);
            }
        }
    }

    private static class FactoryLegacyProvider<T>
    extends LegacyProvider<T> {
        private final Method method;
        private final Key<?> factoryKey;

        FactoryLegacyProvider(Class<T> type, Key<?> factoryKey, String methodName, Key<?> ... paramTypes) {
            super((Class)type, (Key[])paramTypes);
            this.factoryKey = factoryKey;
            this.method = LegacyProvider.findMethod(factoryKey.getTypeLiteral().getRawType(), methodName, paramTypes);
        }

        @Override
        public T get(Injector injector) {
            Object factory = Modifier.isStatic(this.method.getModifiers()) ? null : injector.getInstance(this.factoryKey);
            try {
                return this.providedType.cast(Proxy.invoker(this.method).invoke(factory, this.getParameterValues(injector)));
            }
            catch (Exception e) {
                throw MycilaGuiceException.runtime(e);
            }
        }
    }

    private static class ConstructorLegacyProvider<T>
    extends LegacyProvider<T> {
        private final Constructor<T> constructor;

        ConstructorLegacyProvider(Class<T> type, Key<?> ... parametersTypes) {
            super((Class)type, (Key[])parametersTypes);
            try {
                this.constructor = type.getDeclaredConstructor(LegacyProvider.toClasses(parametersTypes));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }

        @Override
        public T get(Injector injector) {
            try {
                if (!this.constructor.isAccessible()) {
                    this.constructor.setAccessible(true);
                }
                return this.constructor.newInstance(this.getParameterValues(injector));
            }
            catch (Exception e) {
                throw MycilaGuiceException.runtime(e);
            }
        }
    }

    public static class ConstructBuilder<T> {
        private final Class<T> type;

        private ConstructBuilder(Class<T> type) {
            this.type = type;
        }

        public LegacyProvider<T> withDefaultConstructor() {
            return this.withConstructor(new Key[0]);
        }

        public LegacyProvider<T> withConstructor(Class<?> ... paramTypes) {
            return this.withConstructor(LegacyProvider.toKeys(paramTypes));
        }

        public LegacyProvider<T> withConstructor(Key<?> ... paramKeys) {
            return new ConstructorLegacyProvider<T>(this.type, paramKeys);
        }

        public LegacyProvider<T> withFactory(Class<?> factoryType, String methodName, Class<?> ... paramTypes) {
            return this.withFactory(Key.get(factoryType), methodName, LegacyProvider.toKeys(paramTypes));
        }

        public LegacyProvider<T> withFactory(Key<?> factoryType, String methodName, Key<?> ... paramTypes) {
            return new FactoryLegacyProvider<T>(this.type, factoryType, methodName, paramTypes);
        }
    }
}

