/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.scope;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.mycila.inject.annotation.Jsr250Singleton;
import com.mycila.inject.jsr250.Jsr250;
import com.mycila.inject.scope.MycilaScope;
import java.util.concurrent.TimeUnit;

@Jsr250Singleton
public final class RenewableSingleton
extends MycilaScope {
    final long expirationDelay;

    public RenewableSingleton(long expirationDelay, TimeUnit unit) {
        this.expirationDelay = unit.toMillis(expirationDelay);
    }

    public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
        return new Provider<T>(){
            private volatile T instance;
            private volatile long expirationTime;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T get() {
                if (this.expirationTime < System.currentTimeMillis()) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.expirationTime < System.currentTimeMillis()) {
                            Object old = this.instance;
                            if (RenewableSingleton.this.hasJSR250Module) {
                                Jsr250.preDestroy(old);
                            }
                            this.instance = creator.get();
                            this.expirationTime = System.currentTimeMillis() + RenewableSingleton.this.expirationDelay;
                        }
                    }
                }
                return this.instance;
            }

            public String toString() {
                return String.format("%s[%s]", creator, RenewableSingleton.this);
            }
        };
    }
}

