/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.config;

import com.nhncorp.lucy.security.xss.config.AttributeRule;
import com.nhncorp.lucy.security.xss.config.ElementRule;
import com.nhncorp.lucy.security.xss.event.AttributeListener;
import com.nhncorp.lucy.security.xss.event.ElementListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XssConfiguration {
    private static final String DEFAULT_CONFIG = "/lucy-xss-default.xml";
    private Map<String, ElementRule> tags = new HashMap<String, ElementRule>();
    private Map<String, AttributeRule> atts = new HashMap<String, AttributeRule>();
    private Map<String, Set<String>> tagGroups = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> attGroups = new HashMap<String, Set<String>>();
    private String service = "UnknownService";
    private boolean blockingPrefixEnabled;
    private String blockingPrefix = "diabled_";
    private boolean filteringTagInCommentEnabled = true;
    private String filteringTagInCommentType = "strict";
    private Map<String, Set<String>> childElementRef = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> childElementGroupRef = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> parentElementGroupRef = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> childAttrRef = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> childAttrGroupRef = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> parentAttrGroupRef = new HashMap<String, Set<String>>();

    private XssConfiguration() {
    }

    public static XssConfiguration newInstance(String file) throws Exception {
        XssConfiguration config = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            config = XssConfiguration.create(builder, file);
            if (config == null) {
                throw new Exception(String.format("The XSS configuration file [%s] is not a expected xml document.", file));
            }
        }
        catch (Exception ex) {
            throw new Exception(String.format("Cannot parse the XSS configuration file [%s].", file), ex);
        }
        config.closeConfigurationResource();
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XssConfiguration create(DocumentBuilder builder, String file) throws SAXException, IOException {
        XssConfiguration config = null;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (is == null) {
            is = XssConfiguration.class.getResourceAsStream(DEFAULT_CONFIG);
        }
        try {
            int i;
            Element root = builder.parse(is).getDocumentElement();
            String extend = root.getAttribute("extends");
            if (extend != null && !"".equals(extend)) {
                config = XssConfiguration.create(builder, extend);
            }
            if (config == null) {
                config = new XssConfiguration();
            }
            NodeList list = root.getElementsByTagName("elementGroup");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.addElementGroup((Element)Element.class.cast(list.item(i)));
            }
            list = root.getElementsByTagName("attributeGroup");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.addAttributeGroup((Element)Element.class.cast(list.item(i)));
            }
            list = root.getElementsByTagName("element");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.addElementRule((Element)Element.class.cast(list.item(i)));
            }
            list = root.getElementsByTagName("attribute");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.addAttributeRule((Element)Element.class.cast(list.item(i)));
            }
            list = root.getElementsByTagName("blockingPrefix");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.enableBlockingPrefix((Element)Element.class.cast(list.item(i)));
            }
            list = root.getElementsByTagName("filteringTagInComment");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.enableFilteringTagInComment((Element)Element.class.cast(list.item(i)));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        return config;
    }

    private void enableBlockingPrefix(Element element) {
        String enable = element.getAttribute("enable");
        String prefix = element.getAttribute("prefix");
        if (enable != null && ("true".equalsIgnoreCase(enable) || "false".equalsIgnoreCase(enable))) {
            this.setBlockingPrefixEnabled("true".equalsIgnoreCase(enable));
        }
        if (prefix != null && !prefix.isEmpty()) {
            this.setBlockingPrefix(prefix);
        }
    }

    public ElementRule getElementRule(String tagName) {
        ElementRule rule = null;
        if (tagName != null && this.tags != null && !this.tags.isEmpty()) {
            rule = this.tags.get(tagName.toLowerCase());
        }
        return rule;
    }

    public AttributeRule getAttributeRule(String attName) {
        AttributeRule rule = null;
        if (attName != null && this.atts != null && !this.atts.isEmpty()) {
            rule = this.atts.get(attName.toLowerCase());
        }
        return rule;
    }

    private void addElementRule(Element element) {
        NodeList list;
        String name = element.getAttribute("name");
        boolean override = !"false".equalsIgnoreCase(element.getAttribute("override"));
        String endTag = element.getAttribute("endTag");
        String disable = element.getAttribute("disable");
        String removeTag = element.getAttribute("removeTag");
        if (name == null || "".equals(name)) {
            return;
        }
        ElementRule rule = null;
        if (override) {
            rule = this.tags.get(name);
        }
        if (rule == null || !override) {
            rule = new ElementRule(name);
            this.tags.put(name.toLowerCase(), rule);
        }
        if (endTag != null && ("true".equalsIgnoreCase(endTag) || "false".equalsIgnoreCase(endTag))) {
            rule.setEndTag("true".equalsIgnoreCase(endTag));
        }
        if (removeTag != null && ("true".equalsIgnoreCase(removeTag) || "false".equalsIgnoreCase(removeTag))) {
            rule.setRemoveTag("true".equalsIgnoreCase(removeTag));
        }
        if (disable != null && ("true".equalsIgnoreCase(disable) || "false".equalsIgnoreCase(disable))) {
            rule.setDisabled("true".equalsIgnoreCase(disable));
        }
        if ((list = element.getElementsByTagName("attributes")) != null && list.getLength() > 0) {
            Element attributes = (Element)Element.class.cast(list.item(0));
            list = attributes.getChildNodes();
            this.addAttrGroupRef(list, name);
            rule.addAllowedAttributes(this.getReferences(list, this.attGroups, null));
        }
        if ((list = element.getElementsByTagName("elements")) != null && list.getLength() > 0) {
            Element elements = (Element)Element.class.cast(list.item(0));
            list = elements.getChildNodes();
            this.addElementGroupRef(list, name);
            rule.addAllowedElements(this.getReferences(list, this.tagGroups, null));
        }
        list = element.getElementsByTagName("listener");
        for (int i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            String className = list.item(i).getTextContent();
            if (className == null) continue;
            try {
                Object obj = Class.forName(className.trim()).newInstance();
                rule.addListener((ElementListener)ElementListener.class.cast(obj));
                continue;
            }
            catch (Exception ex) {
                System.out.println(name + "\ud0dc\uadf8\uc758 " + className + "(ElementListener) \uc124\uc815 \uc911 \uc624\ub958 \ubc1c\uc0dd. xml \uc124\uc815\uc744 \ud655\uc778\ud558\uc138\uc694. " + ex.toString());
            }
        }
    }

    private void addAttributeRule(Element element) {
        int i;
        String[] tokens;
        String name = element.getAttribute("name");
        boolean override = !"false".equalsIgnoreCase(element.getAttribute("override"));
        String disable = element.getAttribute("disable");
        String base64Decoding = element.getAttribute("base64Decoding");
        String exceptionTagList = element.getAttribute("exceptionTagList");
        if (name == null || "".equals(name)) {
            return;
        }
        AttributeRule rule = null;
        if (override) {
            rule = this.atts.get(name);
        }
        if (rule == null || !override) {
            rule = new AttributeRule(name);
            this.atts.put(name.toLowerCase(), rule);
        }
        if (disable != null && ("true".equalsIgnoreCase(disable) || "false".equalsIgnoreCase(disable))) {
            rule.setDisabled("true".equalsIgnoreCase(disable));
        }
        if (exceptionTagList != null && exceptionTagList.length() > 0 && (tokens = exceptionTagList.split(",")) != null) {
            for (i = 0; i < tokens.length; ++i) {
                if (tokens[i] == null) continue;
                String exceptionTag = tokens[i].trim();
                rule.addExceptionTag(exceptionTag);
            }
        }
        if (base64Decoding != null && ("true".equalsIgnoreCase(base64Decoding) || "false".equalsIgnoreCase(base64Decoding))) {
            rule.setBase64Decoding("true".equalsIgnoreCase(base64Decoding));
        }
        NodeList list = element.getElementsByTagName("allowedPattern");
        for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            rule.addAllowedPattern(list.item(i).getTextContent());
        }
        list = element.getElementsByTagName("notAllowedPattern");
        for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            rule.addNotAllowedPattern(list.item(i).getTextContent());
        }
        list = element.getElementsByTagName("listener");
        for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            String className = list.item(i).getTextContent();
            if (className == null) continue;
            try {
                Object obj = Class.forName(className.trim()).newInstance();
                rule.addListener((AttributeListener)AttributeListener.class.cast(obj));
                continue;
            }
            catch (Exception ex) {
                System.out.println(name + "\uc18d\uc131\uc758 " + className + "(AttributeListener) \uc124\uc815 \uc911 \uc624\ub958 \ubc1c\uc0dd. xml \uc124\uc815\uc744 \ud655\uc778\ud558\uc138\uc694. " + ex.toString());
            }
        }
    }

    private void addElementGroup(Element element) {
        Set<String> elementSet;
        HashSet<String> nestedGroups;
        NodeList list;
        Collection<String> refs;
        boolean override;
        String name = element.getAttribute("name");
        boolean bl = override = !"false".equalsIgnoreCase(element.getAttribute("override"));
        if (name == null || "".equals(name)) {
            return;
        }
        Set<String> tagGroup = null;
        if (override) {
            tagGroup = this.tagGroups.get(name);
        }
        if (tagGroup == null) {
            tagGroup = new HashSet<String>();
        }
        if ((refs = this.getReferences(list = element.getElementsByTagName("ref"), this.tagGroups, nestedGroups = new HashSet<String>())) != null && !refs.isEmpty()) {
            tagGroup.addAll(refs);
        }
        if (nestedGroups != null && !nestedGroups.isEmpty()) {
            HashSet childGroup = new HashSet();
            for (String nestedGroup : nestedGroups) {
                Set<String> parentElementGroup;
                if (this.childElementGroupRef.containsKey(nestedGroup)) {
                    childGroup.addAll(this.childElementGroupRef.get(nestedGroup));
                }
                if ((parentElementGroup = this.parentElementGroupRef.get(nestedGroup)) == null) {
                    parentElementGroup = new HashSet<String>();
                }
                parentElementGroup.add(name);
                this.parentElementGroupRef.put(nestedGroup, parentElementGroup);
            }
            if (!childGroup.isEmpty()) {
                nestedGroups.addAll(childGroup);
            }
            this.childElementGroupRef.put(name, nestedGroups);
        }
        this.tagGroups.put(name, tagGroup);
        if (this.parentElementGroupRef.containsKey(name)) {
            for (String parentName : this.parentElementGroupRef.get(name)) {
                this.tagGroups.get(parentName).addAll(tagGroup);
            }
        }
        if (override && (elementSet = this.childElementRef.get(name)) != null) {
            for (String tagName : elementSet) {
                ElementRule rule = this.tags.get(tagName);
                rule.addAllowedElements(refs);
            }
        }
    }

    private void addAttributeGroup(Element element) {
        Set<String> elementSet;
        HashSet<String> nestedGroups;
        NodeList list;
        Collection<String> refs;
        boolean override;
        String name = element.getAttribute("name");
        boolean bl = override = !"false".equalsIgnoreCase(element.getAttribute("override"));
        if (name == null || "".equals(name)) {
            return;
        }
        Set<String> attGroup = null;
        if (override) {
            attGroup = this.attGroups.get(name);
        }
        if (attGroup == null) {
            attGroup = new HashSet<String>();
        }
        if ((refs = this.getReferences(list = element.getElementsByTagName("ref"), this.attGroups, nestedGroups = new HashSet<String>())) != null && !refs.isEmpty()) {
            attGroup.addAll(refs);
        }
        if (nestedGroups != null && !nestedGroups.isEmpty()) {
            HashSet childGroup = new HashSet();
            for (String nestedGroup : nestedGroups) {
                Set<String> parentElementGroup;
                if (this.childAttrGroupRef.containsKey(nestedGroup)) {
                    childGroup.addAll(this.childAttrGroupRef.get(nestedGroup));
                }
                if ((parentElementGroup = this.parentAttrGroupRef.get(nestedGroup)) == null) {
                    parentElementGroup = new HashSet<String>();
                }
                parentElementGroup.add(name);
                this.parentAttrGroupRef.put(nestedGroup, parentElementGroup);
            }
            if (!childGroup.isEmpty()) {
                nestedGroups.addAll(childGroup);
            }
            this.childAttrGroupRef.put(name, nestedGroups);
        }
        this.attGroups.put(name, attGroup);
        if (this.parentAttrGroupRef.containsKey(name)) {
            for (String parentName : this.parentAttrGroupRef.get(name)) {
                this.attGroups.get(parentName).addAll(attGroup);
            }
        }
        if (override && (elementSet = this.childAttrRef.get(name)) != null) {
            for (String tagName : elementSet) {
                ElementRule rule = this.tags.get(tagName);
                rule.addAllowedAttributes(refs);
            }
        }
    }

    private void addElementGroupRef(NodeList list, String tagName) {
        for (int i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("ref")) continue;
            Element ref = (Element)Element.class.cast(node);
            String tagGroupName = ref.getAttribute("name");
            HashSet<String> nestedGroupNames = new HashSet<String>();
            if (!this.tagGroups.containsKey(tagGroupName)) continue;
            nestedGroupNames.add(tagGroupName);
            Set<String> tagGroupSet = this.childElementGroupRef.get(tagGroupName);
            if (tagGroupSet != null) {
                nestedGroupNames.addAll(tagGroupSet);
            }
            for (String groupName : nestedGroupNames) {
                if (this.childElementRef.containsKey(groupName)) {
                    Set<String> elementList = this.childElementRef.get(groupName);
                    elementList.add(tagName);
                    continue;
                }
                HashSet<String> newElementSet = new HashSet<String>();
                newElementSet.add(tagName);
                this.childElementRef.put(groupName, newElementSet);
            }
        }
    }

    private void addAttrGroupRef(NodeList list, String tagName) {
        for (int i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("ref")) continue;
            Element ref = (Element)Element.class.cast(node);
            String attGroupName = ref.getAttribute("name");
            HashSet<String> nestedAttNames = new HashSet<String>();
            if (!this.attGroups.containsKey(attGroupName)) continue;
            nestedAttNames.add(attGroupName);
            Set<String> attGroupSet = this.childAttrGroupRef.get(attGroupName);
            if (attGroupSet != null) {
                nestedAttNames.addAll(attGroupSet);
            }
            for (String groupName : nestedAttNames) {
                if (this.childAttrRef.containsKey(groupName)) {
                    Set<String> elementList = this.childAttrRef.get(groupName);
                    elementList.add(tagName);
                    continue;
                }
                HashSet<String> newElementSet = new HashSet<String>();
                newElementSet.add(tagName);
                this.childAttrRef.put(groupName, newElementSet);
            }
        }
    }

    private Collection<String> getReferences(NodeList list, Map<String, Set<String>> groups, Set<String> nestedGroups) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("ref")) continue;
            Element ref = (Element)Element.class.cast(node);
            String name = ref.getAttribute("name");
            if (groups.containsKey(name)) {
                Collection<String> tmp;
                if (nestedGroups != null) {
                    nestedGroups.add(name);
                }
                HashSet names = new HashSet(groups.get(name));
                NodeList excludes = ref.getElementsByTagName("excludes");
                if (excludes != null && excludes.getLength() > 0 && (tmp = this.getReferences(((Element)Element.class.cast(excludes.item(0))).getElementsByTagName("ref"), groups, null)) != null && !tmp.isEmpty()) {
                    names.removeAll(tmp);
                }
                if (names.isEmpty()) continue;
                result.addAll(names);
                continue;
            }
            result.add(name);
        }
        return result;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public void setBlockingPrefixEnabled(boolean isEnableBlockingPrefix) {
        this.blockingPrefixEnabled = isEnableBlockingPrefix;
    }

    public boolean isEnableBlockingPrefix() {
        return this.blockingPrefixEnabled;
    }

    public void setBlockingPrefix(String blockingPrefix) {
        this.blockingPrefix = blockingPrefix;
    }

    public String getBlockingPrefix() {
        return this.blockingPrefix;
    }

    public void closeConfigurationResource() {
        this.childElementRef = null;
        this.childElementGroupRef = null;
        this.parentElementGroupRef = null;
        this.childAttrGroupRef = null;
        this.childAttrRef = null;
        this.parentAttrGroupRef = null;
    }

    private void enableFilteringTagInComment(Element element) {
        String enable = element.getAttribute("enable");
        String type = element.getAttribute("type");
        if (enable != null && ("true".equalsIgnoreCase(enable) || "false".equalsIgnoreCase(enable))) {
            this.setFilteringTagInCommentEnabled("true".equalsIgnoreCase(enable));
        }
        if (type != null && !type.isEmpty()) {
            this.setFilteringTagInCommentType(type);
        }
    }

    private void setFilteringTagInCommentType(String type) {
        this.filteringTagInCommentType = type;
    }

    private void setFilteringTagInCommentEnabled(boolean enabled) {
        this.filteringTagInCommentEnabled = enabled;
    }

    public boolean isFilteringTagInCommentEnabled() {
        return this.filteringTagInCommentEnabled;
    }

    public boolean isNoTagAllowedInComment() {
        return "strict".endsWith(this.filteringTagInCommentType);
    }
}

