/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.listener;

import com.nhncorp.lucy.security.xss.Constants;
import com.nhncorp.lucy.security.xss.listener.ContentType;
import com.nhncorp.lucy.security.xss.listener.ContentTypeCacheRepo;
import com.nhncorp.lucy.security.xss.markup.Element;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SecurityUtils {
    private static final String EXTENSION_PROPERTIES = "xssfilter-extension.properties";
    private static final char[] specialCharArray = "?&=".toCharArray();
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static Properties props;

    public static boolean checkVulnerable(Element element, String srcUrl, boolean isWhiteUrl) {
        boolean isVulnerable = false;
        if (!isWhiteUrl) {
            String type = element.getAttributeValue("type").trim();
            if ((type = StringUtils.strip((String)type, (String)"'\"")) != null && type.length() != 0) {
                if (!SecurityUtils.isAllowedType(type) && !props.values().contains(type)) {
                    isVulnerable = true;
                }
            } else {
                int pos;
                String url = StringUtils.strip((String)srcUrl, (String)"'\"");
                String extension = SecurityUtils.getExtension(url);
                if (StringUtils.containsAny((CharSequence)extension, (char[])specialCharArray) && (pos = StringUtils.indexOfAny((CharSequence)extension, (char[])specialCharArray)) != -1) {
                    extension = StringUtils.substring((String)extension, (int)0, (int)pos);
                }
                if (!StringUtils.isEmpty((CharSequence)extension)) {
                    type = SecurityUtils.getTypeFromExtension(extension);
                    if (StringUtils.isEmpty((CharSequence)type) && (type = props.getProperty(extension)) != null) {
                        type = type.trim();
                    }
                    if (StringUtils.isEmpty((CharSequence)type)) {
                        isVulnerable = true;
                    } else {
                        element.putAttribute("type", "\"" + type + "\"");
                    }
                }
            }
        }
        return isVulnerable;
    }

    public static boolean checkVulnerableWithHttp(Element element, String srcUrl, boolean isWhiteUrl, ContentTypeCacheRepo contentTypeCacheRepo) {
        boolean isVulnerable = false;
        if (!isWhiteUrl) {
            String type = element.getAttributeValue("type").trim();
            if ((type = StringUtils.strip((String)type, (String)"'\"")) != null && !"".equals(type)) {
                if (!SecurityUtils.isAllowedType(type) && !props.values().contains(type)) {
                    isVulnerable = true;
                }
            } else {
                int pos;
                String url = StringUtils.strip((String)srcUrl, (String)"'\"");
                String extension = SecurityUtils.getExtension(url);
                if (StringUtils.containsAny((CharSequence)extension, (char[])specialCharArray) && (pos = StringUtils.indexOfAny((CharSequence)extension, (char[])specialCharArray)) != -1) {
                    extension = StringUtils.substring((String)extension, (int)0, (int)pos);
                }
                if (StringUtils.isEmpty((CharSequence)extension)) {
                    type = SecurityUtils.getContentTypeFromUrlConnection(url, contentTypeCacheRepo);
                    if (!SecurityUtils.isAllowedType(type)) {
                        isVulnerable = true;
                    } else {
                        element.putAttribute("type", "\"" + type + "\"");
                    }
                } else {
                    type = SecurityUtils.getTypeFromExtension(extension);
                    if (StringUtils.isEmpty((CharSequence)type) && (type = props.getProperty(extension)) != null) {
                        type = type.trim();
                    }
                    if (StringUtils.isEmpty((CharSequence)type)) {
                        isVulnerable = true;
                    } else {
                        element.putAttribute("type", "\"" + type + "\"");
                    }
                }
            }
        }
        return isVulnerable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentTypeFromUrlConnection(String strUrl, ContentTypeCacheRepo contentTypeCacheRepo) {
        String result = contentTypeCacheRepo.getContentTypeFromCache(strUrl);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return result;
        }
        HttpURLConnection con = null;
        try {
            URL url = new URL(strUrl);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            con.connect();
            int resCode = con.getResponseCode();
            if (resCode != 200) {
                System.err.println("error");
            } else {
                result = con.getContentType();
                if (result != null) {
                    contentTypeCacheRepo.addContentTypeToCache(strUrl, new ContentType(result, new Date()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return result;
    }

    public static String getTypeFromExtension(String extension) {
        return Constants.mimeTypes.get(extension);
    }

    public static boolean isAllowedType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        if (StringUtils.startsWith((CharSequence)type, (CharSequence)"text/")) {
            return false;
        }
        return !StringUtils.isNotEmpty((CharSequence)type) || Constants.mimeTypes.values().contains(type);
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = SecurityUtils.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = SecurityUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    static {
        try {
            props = new Properties();
            props.load(SecurityUtils.class.getClassLoader().getResourceAsStream(EXTENSION_PROPERTIES));
        }
        catch (Exception e) {
            System.out.println("xssfilter-extension.properties \ud30c\uc77c\uc744 \ucc3e\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }
}

