/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.adapter;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.StrategyEntity;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.adapter.DiscoveryEnabledAdapter;
import com.nepxion.discovery.plugin.strategy.adapter.DiscoveryEnabledStrategy;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDiscoveryEnabledAdapter
implements DiscoveryEnabledAdapter {
    @Autowired(required=false)
    private DiscoveryEnabledStrategy discoveryEnabledStrategy;
    @Autowired
    protected PluginAdapter pluginAdapter;

    @Override
    public boolean apply(Server server, Map<String, String> metadata) {
        boolean enabled = this.applyVersion(server, metadata);
        if (!enabled) {
            return false;
        }
        enabled = this.applyRegion(server, metadata);
        if (!enabled) {
            return false;
        }
        enabled = this.applyAddress(server, metadata);
        if (!enabled) {
            return false;
        }
        return this.applyStrategy(server, metadata);
    }

    private boolean applyVersion(Server server, Map<String, String> metadata) {
        StrategyEntity strategyEntity;
        RuleEntity ruleEntity;
        String versionValue = this.getVersionValue(server);
        if (StringUtils.isEmpty((CharSequence)versionValue) && (ruleEntity = this.pluginAdapter.getRule()) != null && (strategyEntity = ruleEntity.getStrategyEntity()) != null) {
            versionValue = strategyEntity.getVersionValue();
        }
        if (StringUtils.isEmpty((CharSequence)versionValue)) {
            return true;
        }
        String version = metadata.get("version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            return false;
        }
        String versions = null;
        try {
            Map versionMap = (Map)JsonUtil.fromJson((String)versionValue, Map.class);
            String serviceId = this.pluginAdapter.getServerServiceId(server);
            versions = (String)versionMap.get(serviceId);
        }
        catch (Exception e) {
            versions = versionValue;
        }
        if (StringUtils.isEmpty((CharSequence)versions)) {
            return true;
        }
        List versionList = StringUtil.splitToList((String)versions, (String)";");
        return versionList.contains(version);
    }

    private boolean applyRegion(Server server, Map<String, String> metadata) {
        StrategyEntity strategyEntity;
        RuleEntity ruleEntity;
        String regionValue = this.getRegionValue(server);
        if (StringUtils.isEmpty((CharSequence)regionValue) && (ruleEntity = this.pluginAdapter.getRule()) != null && (strategyEntity = ruleEntity.getStrategyEntity()) != null) {
            regionValue = strategyEntity.getRegionValue();
        }
        if (StringUtils.isEmpty((CharSequence)regionValue)) {
            return true;
        }
        String region = metadata.get("region");
        if (StringUtils.isEmpty((CharSequence)region)) {
            return false;
        }
        String regions = null;
        try {
            Map regionMap = (Map)JsonUtil.fromJson((String)regionValue, Map.class);
            String serviceId = this.pluginAdapter.getServerServiceId(server);
            regions = (String)regionMap.get(serviceId);
        }
        catch (Exception e) {
            regions = regionValue;
        }
        if (StringUtils.isEmpty((CharSequence)regions)) {
            return true;
        }
        List regionList = StringUtil.splitToList((String)regions, (String)";");
        return regionList.contains(region);
    }

    private boolean applyAddress(Server server, Map<String, String> metadata) {
        String serviceId;
        StrategyEntity strategyEntity;
        RuleEntity ruleEntity;
        String addressValue = this.getAddressValue(server);
        if (StringUtils.isEmpty((CharSequence)addressValue) && (ruleEntity = this.pluginAdapter.getRule()) != null && (strategyEntity = ruleEntity.getStrategyEntity()) != null) {
            addressValue = strategyEntity.getAddressValue();
        }
        if (StringUtils.isEmpty((CharSequence)addressValue)) {
            return true;
        }
        Map addressMap = (Map)JsonUtil.fromJson((String)addressValue, Map.class);
        String addresses = (String)addressMap.get(serviceId = this.pluginAdapter.getServerServiceId(server));
        if (StringUtils.isEmpty((CharSequence)addresses)) {
            return true;
        }
        List addressList = StringUtil.splitToList((String)addresses, (String)";");
        return addressList.contains(server.getHostPort()) || addressList.contains(server.getHost());
    }

    private boolean applyStrategy(Server server, Map<String, String> metadata) {
        if (this.discoveryEnabledStrategy == null) {
            return true;
        }
        return this.discoveryEnabledStrategy.apply(server, metadata);
    }

    protected abstract String getVersionValue(Server var1);

    protected abstract String getRegionValue(Server var1);

    protected abstract String getAddressValue(Server var1);
}

