package com.networkbench.newlens.agent.android

import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.logging.Logger

public class NetworkBenchNewLensGradlePlugin implements Plugin<Project> {

	def static Logger logger
	def void apply(Project project) {
		
		logger=project.getLogger()
		logger.info("[NewLens] NetworkBench NewLens plugin loaded.")
		project.configure(project){
			if(it.hasProperty("android")){
		
				//闭环1完全一样了
				project.task('networkBenchNewLensInstrumentTask',type: NetworkBenchNewLensInstrumentTask)
				project.task('networkBenchNewLensDeinstrumentTask',type: NetworkBenchNewLensDeinstrumentTask)

				android.applicationVariants.all{
					variant->
						///闭环2和3完全一样了 ,完全没问题了,

						variant.dex.dependsOn(networkBenchNewLensInstrumentTask)
						variant.dex.finalizedBy(networkBenchNewLensDeinstrumentTask)
						return logger.info("[NewLens] Added instrumentation tasks to "+variant.name+" variant.")
				}
				android.testVariants.all{
					variant->
						variant.dex.dependsOn(networkBenchNewLensInstrumentTask)
						variant.dex.finalizedBy(networkBenchNewLensDeinstrumentTask)
						return logger.info("[NewLens] Added instrumentation tasks to "+variant.name+" variant.")
				}
			}
		}
		
	}	
}
