package com.networkbench.newlens.agent.android;

import com.networkbench.agent.compile.NBSStubPreMain;
import com.sun.tools.attach.VirtualMachine;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;

public class NetworkBenchNewLensGradlePlugin implements Plugin<Project> {

    public void apply(Project target) {
        Logger logger = target.getLogger();

        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();

        int p = nameOfRunningVM.indexOf('@');
        String pid = nameOfRunningVM.substring(0, p);


        logger.info("[NBSAgent] Dynamically loading NetworkBench NewLens Android Agent instrumentation...");
        String jarFilePath;
        try {
            jarFilePath = NBSStubPreMain.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().toString();

            jarFilePath = new File(jarFilePath).getCanonicalPath();

            logger.info("[NBSAgent] Found NetworkBench NewLens Android Agent instrumentation within " + jarFilePath);
        } catch (URISyntaxException e) {
            logger.error("[NBSAgent] Unable to find NetworkBench NewLens Android Agent instrumentation jar");
            throw new RuntimeException(e);
        } catch (IOException e) {
            logger.error("[NBSAgent] Unable to find NetworkBench NewLens Android Agent instrumentation jar");
            throw new RuntimeException(e);
        }
        try {
            VirtualMachine vm = VirtualMachine.attach(pid);
            vm.loadAgent(jarFilePath, System.getProperty("NewLens.AgentArgs"));
            vm.detach();
        } catch (Exception e) {
            logger.error("[NBSAgent] Error encountered while loading the NetworkBench NewLens Android agent", e);
            throw new RuntimeException(e);
        }
    }
}

