package com.networkbench.newlens.agent.android

import org.gradle.api.DefaultTask
import org.gradle.api.logging.Logger
import com.networkbench.agent.compile.NBSStubPreMain
import com.sun.tools.attach.VirtualMachine
import java.lang.management.ManagementFactory;


class NetworkBenchNewLensTask extends DefaultTask{
	 protected Logger looger = NetworkBenchNewLensGradlePlugin.getLogger()

	 
	def getpid(){
		String nameOfRunningVM=ManagementFactory.getRuntimeMXBean().getName()
		int p=nameOfRunningVM.indexOf("@")
		return nameOfRunningVM.substring(0, p)
	}
	def getJarFilePath(){
		
		try {
			//修改类为NBSStubPreMain
			String jarFilePath=NBSStubPreMain.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()
			jarFilePath=new File(jarFilePath).getCanonicalPath()
			logger.info("[NewLens] Found NetworkBench NewLens Android Agent instrumentation within " + jarFilePath)
			return jarFilePath;
		}
		catch (URISyntaxException e) {
			logger.error("[NewLens] Unable to find NetworkBench NewLens Android Agent instrumentation jar")
			 throw new RuntimeException(e)
		}
		catch (IOException e) {
			logger.error("[NewLens] Unable to find NetworkBench NewLens Android Agent instrumentation jar")
			 throw new RuntimeException(e)
		}
	}
	def injectAgent(String agentArgs){
	    logger.info("[NewLens] injectAgent.............................")
		VirtualMachine vm =VirtualMachine.attach(getpid())
		vm.loadAgent(this.getJarFilePath(),agentArgs)
		vm.detach()
	}
}

