/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.wordtoimage;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.backgroundgenerator.BackgroundGenerator;
import com.octo.captcha.component.image.deformation.ImageDeformation;
import com.octo.captcha.component.image.fontgenerator.FontGenerator;
import com.octo.captcha.component.image.textpaster.TextPaster;
import com.octo.captcha.component.image.wordtoimage.ComposedWordToImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.AttributedString;

public class DeformedComposedWordToImage
extends ComposedWordToImage {
    private ImageDeformation[] backgroundDeformation;
    private ImageDeformation[] textDeformation;
    private ImageDeformation[] finalDeformation;

    public DeformedComposedWordToImage(FontGenerator fontGenerator, BackgroundGenerator background, TextPaster textPaster, ImageDeformation backgroundDeformation, ImageDeformation textDeformation, ImageDeformation finalDeformation) {
        super(fontGenerator, background, textPaster);
        this.backgroundDeformation = new ImageDeformation[]{backgroundDeformation};
        this.textDeformation = new ImageDeformation[]{textDeformation};
        this.finalDeformation = new ImageDeformation[]{finalDeformation};
    }

    public DeformedComposedWordToImage(FontGenerator fontGenerator, BackgroundGenerator background, TextPaster textPaster, ImageDeformation[] backgroundDeformation, ImageDeformation[] textDeformation, ImageDeformation[] finalDeformation) {
        super(fontGenerator, background, textPaster);
        this.backgroundDeformation = backgroundDeformation;
        this.textDeformation = textDeformation;
        this.finalDeformation = finalDeformation;
    }

    public BufferedImage getImage(String word) throws CaptchaException {
        BufferedImage background = this.getBackround();
        AttributedString aword = this.getAttributedString(word, this.checkWordLength(word));
        BufferedImage out = new BufferedImage(background.getWidth(), background.getHeight(), background.getType());
        Graphics2D g2 = (Graphics2D)out.getGraphics();
        g2.drawImage(background, 0, 0, out.getWidth(), out.getHeight(), null);
        g2.dispose();
        for (int i = 0; i < this.backgroundDeformation.length; ++i) {
            out = this.backgroundDeformation[i].deformImage(out);
        }
        BufferedImage transparent = new BufferedImage(out.getWidth(), out.getHeight(), 2);
        transparent = this.pasteText(transparent, aword);
        for (int i = 0; i < this.textDeformation.length; ++i) {
            transparent = this.textDeformation[i].deformImage(transparent);
        }
        Graphics2D g3 = (Graphics2D)out.getGraphics();
        g3.drawImage((Image)transparent, 0, 0, null);
        g3.dispose();
        for (int i = 0; i < this.finalDeformation.length; ++i) {
            out = this.finalDeformation[i].deformImage(out);
        }
        return out;
    }
}

