/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.bufferedengine;

import com.octo.captcha.engine.CaptchaEngineException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;

public class ContainerConfiguration {
    private Integer feedSize;
    private Integer swapSize;
    private Integer maxVolatileMemorySize;
    private Integer maxPersistentMemorySize;
    private HashedMap localeRatio = new HashedMap();
    private boolean serveOnlyConfiguredLocales = false;
    private Locale defaultLocale = Locale.getDefault();
    private Integer feedBatchSize;

    public ContainerConfiguration(Map localeRatio, int maxVolatileMemorySize, int maxPersistentMemorySize, int swapSize, int feedSize) {
        this.localeRatio.putAll(localeRatio);
        this.maxVolatileMemorySize = new Integer(maxVolatileMemorySize);
        this.maxPersistentMemorySize = new Integer(maxPersistentMemorySize);
        this.feedSize = new Integer(feedSize);
        this.swapSize = new Integer(swapSize);
        this.feedBatchSize = new Integer(feedSize);
    }

    public ContainerConfiguration(Map localeRatio, int maxVolatileMemorySize, int maxPersistentMemorySize, int swapSize, int feedSize, boolean serveOnlyConfiguredLocales, Locale defaultLocale) {
        this(localeRatio, maxVolatileMemorySize, maxPersistentMemorySize, swapSize, feedSize);
        this.serveOnlyConfiguredLocales = serveOnlyConfiguredLocales;
        this.defaultLocale = defaultLocale != null ? defaultLocale : this.defaultLocale;
        this.validateDefaultLocale(serveOnlyConfiguredLocales, defaultLocale);
    }

    public ContainerConfiguration(Map localeRatio, int maxVolatileMemorySize, int maxPersistentMemorySize, int swapSize, int feedSize, int feedBatchSize, boolean serveOnlyConfiguredLocales, Locale defaultLocale) {
        this(localeRatio, maxVolatileMemorySize, maxPersistentMemorySize, swapSize, feedSize, serveOnlyConfiguredLocales, defaultLocale);
        this.feedBatchSize = new Integer(feedBatchSize);
    }

    public Integer getFeedBatchSize() {
        return this.feedBatchSize;
    }

    public void setFeedBatchSize(Integer feedBatchSize) {
        this.feedBatchSize = feedBatchSize;
    }

    public boolean isServeOnlyConfiguredLocales() {
        return this.serveOnlyConfiguredLocales;
    }

    public void setServeOnlyConfiguredLocales(boolean serveOnlyConfiguredLocales) {
        this.validateDefaultLocale(serveOnlyConfiguredLocales, this.defaultLocale);
        this.serveOnlyConfiguredLocales = serveOnlyConfiguredLocales;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.validateDefaultLocale(this.serveOnlyConfiguredLocales, defaultLocale);
        this.defaultLocale = defaultLocale;
    }

    private void validateDefaultLocale(boolean serveOnlyConfiguredLocales, Locale defaultLocale) {
        if (!this.getLocaleRatio().containsKey((Object)defaultLocale) && serveOnlyConfiguredLocales) {
            throw new CaptchaEngineException("impossible build a ContainerConfiguration with a default locale that is not in its localeRatio and that serve only configured locales : locale " + defaultLocale);
        }
    }

    public Integer getFeedSize() {
        return this.feedSize;
    }

    public void setFeedSize(Integer feedSize) {
        this.feedSize = feedSize;
    }

    public HashedMap getLocaleRatio() {
        return this.localeRatio;
    }

    public void setLocaleRatio(Map localeRatio) {
        this.localeRatio = new HashedMap(localeRatio.size());
        this.localeRatio.putAll(localeRatio);
    }

    public Integer getMaxPersistentMemorySize() {
        return this.maxPersistentMemorySize;
    }

    public void setMaxPersistentMemorySize(Integer maxPersistentMemorySize) {
        this.maxPersistentMemorySize = maxPersistentMemorySize;
    }

    public Integer getMaxVolatileMemorySize() {
        return this.maxVolatileMemorySize;
    }

    public void setMaxVolatileMemorySize(Integer maxVolatileMemorySize) {
        this.maxVolatileMemorySize = maxVolatileMemorySize;
    }

    public Integer getSwapSize() {
        return this.swapSize;
    }

    public void setSwapSize(Integer swapSize) {
        this.swapSize = swapSize;
    }
}

