/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.image;

import com.octo.captcha.Captcha;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public abstract class ImageCaptcha
implements Captcha {
    private Boolean hasChallengeBeenCalled = Boolean.FALSE;
    protected String question;
    protected transient BufferedImage challenge;

    protected ImageCaptcha(String question, BufferedImage challenge) {
        this.challenge = challenge;
        this.question = question;
    }

    public final String getQuestion() {
        return this.question;
    }

    public final Object getChallenge() {
        return this.getImageChallenge();
    }

    public final BufferedImage getImageChallenge() {
        this.hasChallengeBeenCalled = Boolean.TRUE;
        return this.challenge;
    }

    public final void disposeChallenge() {
        this.challenge = null;
    }

    public Boolean hasGetChalengeBeenCalled() {
        return this.hasChallengeBeenCalled;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.challenge != null) {
            out.defaultWriteObject();
            JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            jpegEncoder.encode(this.challenge);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
        this.challenge = decoder.decodeAsBufferedImage();
    }
}

