/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.query.Template;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Template", generator="Immutables")
@Immutable
public final class ImmutableTemplate
extends Template {
    private final String type;
    @Nullable
    private final String regExp;

    private ImmutableTemplate(String type, @Nullable String regExp) {
        this.type = type;
        this.regExp = regExp;
    }

    @Override
    @JsonProperty(value="Type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="RegExp")
    public Optional<String> getRegExp() {
        return Optional.ofNullable(this.regExp);
    }

    public final ImmutableTemplate withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplate(newValue, this.regExp);
    }

    public final ImmutableTemplate withRegExp(String value) {
        String newValue = Objects.requireNonNull(value, "regExp");
        if (Objects.equals(this.regExp, newValue)) {
            return this;
        }
        return new ImmutableTemplate(this.type, newValue);
    }

    public final ImmutableTemplate withRegExp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.regExp, value)) {
            return this;
        }
        return new ImmutableTemplate(this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTemplate && this.equalTo((ImmutableTemplate)another);
    }

    private boolean equalTo(ImmutableTemplate another) {
        return this.type.equals(another.type) && Objects.equals(this.regExp, another.regExp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.regExp);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Template").omitNullValues().add("type", (Object)this.type).add("regExp", (Object)this.regExp).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTemplate fromJson(Json json) {
        Builder builder = ImmutableTemplate.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.regExp != null) {
            builder.regExp(json.regExp);
        }
        return builder.build();
    }

    public static ImmutableTemplate copyOf(Template instance) {
        if (instance instanceof ImmutableTemplate) {
            return (ImmutableTemplate)instance;
        }
        return ImmutableTemplate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Template", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String type;
        @Nullable
        private String regExp;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Template instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            Optional<String> regExpOptional = instance.getRegExp();
            if (regExpOptional.isPresent()) {
                this.regExp(regExpOptional);
            }
            return this;
        }

        @JsonProperty(value="Type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder regExp(String regExp) {
            this.regExp = Objects.requireNonNull(regExp, "regExp");
            return this;
        }

        @JsonProperty(value="RegExp")
        @CanIgnoreReturnValue
        public final Builder regExp(Optional<String> regExp) {
            this.regExp = regExp.orElse(null);
            return this;
        }

        public ImmutableTemplate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTemplate(this.type, this.regExp);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Template, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Template", generator="Immutables")
    static final class Json
    extends Template {
        @Nullable
        String type;
        @Nullable
        Optional<String> regExp = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="RegExp")
        public void setRegExp(Optional<String> regExp) {
            this.regExp = regExp;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRegExp() {
            throw new UnsupportedOperationException();
        }
    }
}

