/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jaxrs;

import com.owlike.genson.Context;
import com.owlike.genson.GenericType;
import com.owlike.genson.Genson;
import com.owlike.genson.TransformationException;
import com.owlike.genson.annotation.WithBeanView;
import com.owlike.genson.ext.jaxb.JAXBBundle;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"application/json", "text/json", "application/*+json"})
@Produces(value={"application/json", "text/json", "application/*+json"})
public class GensonJsonConverter
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private final ContextResolver<Genson> _gensonResolver;

    public GensonJsonConverter() {
        this(new GensonStandardResolver());
    }

    public GensonJsonConverter(@javax.ws.rs.core.Context Providers providers) {
        ContextResolver gensonResolver = providers.getContextResolver(Genson.class, null);
        this._gensonResolver = gensonResolver == null ? new GensonStandardResolver() : gensonResolver;
    }

    public GensonJsonConverter(ContextResolver<Genson> gensonResolver) {
        this._gensonResolver = gensonResolver;
    }

    private Genson getInstance(Class<?> type) {
        Genson genson = (Genson)this._gensonResolver.getContext(type);
        if (genson == null) {
            throw new NullPointerException("Could not resolve a Genson instance for type " + type + " using ContextResolver " + this._gensonResolver.getClass());
        }
        return genson;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Genson genson = this.getInstance(type);
        ObjectWriter writer = genson.createWriter(new OutputStreamWriter(entityStream, "UTF-8"));
        try {
            genson.serialize(t, genericType, writer, this.createContext(annotations, genson));
            writer.flush();
        }
        catch (TransformationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private Context createContext(Annotation[] annotations, Genson genson) {
        WithBeanView viewAnno = this.find(WithBeanView.class, annotations);
        Context context = null;
        context = viewAnno != null ? new Context(genson, Arrays.asList(viewAnno.views())) : new Context(genson);
        return context;
    }

    private <T extends Annotation> T find(Class<T> annotationClass, Annotation[] inAnnotations) {
        for (Annotation anno : inAnnotations) {
            if (!annotationClass.isInstance(anno)) continue;
            return (T)((Annotation)annotationClass.cast(anno));
        }
        return null;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            Genson genson = this.getInstance(type);
            ObjectReader reader = genson.createReader(new InputStreamReader(entityStream, "UTF-8"));
            return genson.deserialize(GenericType.of(genericType), reader, this.createContext(annotations, genson));
        }
        catch (TransformationException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    private static class GensonStandardResolver
    implements ContextResolver<Genson> {
        private final Genson genson = this.createDefaultInstance();

        public Genson getContext(Class<?> type) {
            return this.genson;
        }

        private final Genson createDefaultInstance() {
            return new Genson.Builder().with(new JAXBBundle()).setWithBeanViewConverter(true).setWithDebugInfoPropertyNameResolver(true).create();
        }
    }
}

