/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.paypal.base.SDKVersion;
import com.paypal.base.rest.OAuthTokenCredential;
import com.paypal.base.rest.PayPalRESTException;
import java.util.Map;
import java.util.UUID;

public class APIContext {
    private String requestId;
    private boolean maskRequestId;
    private SDKVersion sdkVersion;
    private OAuthTokenCredential credential;

    public APIContext() {
        this.credential = new OAuthTokenCredential(null);
    }

    public APIContext(String clientID, String clientSecret, String mode) {
        this(clientID, clientSecret, mode, null);
    }

    public APIContext(String clientID, String clientSecret, String mode, Map<String, String> configurations) {
        this.credential = new OAuthTokenCredential(clientID, clientSecret);
        if (configurations != null && configurations.size() > 0) {
            this.credential.addConfigurations(configurations);
        }
        this.setMode(mode);
    }

    public APIContext(String accessToken) {
        if (accessToken == null || accessToken.length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null");
        }
        this.credential = new OAuthTokenCredential(accessToken);
    }

    public APIContext(String accessToken, String requestId) {
        this(accessToken);
        if (requestId == null || requestId.length() <= 0) {
            throw new IllegalArgumentException("RequestId cannot be null");
        }
        this.requestId = requestId;
    }

    public APIContext setRefreshToken(String refreshToken) {
        if (this.credential == null || !this.credential.hasCredentials()) {
            throw new IllegalArgumentException("ClientID and Secret are required. Please use APIContext(String clientID, String clientSecret, String mode)");
        }
        this.credential.setRefreshToken(refreshToken);
        return this;
    }

    public APIContext setMode(String mode) {
        if (mode == null || !mode.equals("live") && !mode.equals("sandbox")) {
            throw new IllegalArgumentException("Mode needs to be either `sandbox` or `live`.");
        }
        this.credential.addConfiguration("mode", mode);
        return this;
    }

    public APIContext usingGoogleAppEngine(boolean usingGoogleAppEngine) {
        return this.addConfiguration("http.GoogleAppEngine", String.valueOf(usingGoogleAppEngine));
    }

    public Map<String, String> getHTTPHeaders() {
        return this.credential.getHeaders();
    }

    public String getHTTPHeader(String key) {
        return this.credential.getHeader(key);
    }

    public APIContext setHTTPHeaders(Map<String, String> httpHeaders) {
        this.credential.setHeaders(httpHeaders);
        return this;
    }

    public APIContext addHTTPHeaders(Map<String, String> httpHeaders) {
        this.credential.addHeaders(httpHeaders);
        return this;
    }

    public APIContext addHTTPHeader(String key, String value) {
        this.credential.addHeader(key, value);
        return this;
    }

    public Map<String, String> getConfigurationMap() {
        return this.credential.getConfigurations();
    }

    public APIContext setConfigurationMap(Map<String, String> configurationMap) {
        this.credential.setConfigurations(configurationMap);
        return this;
    }

    public APIContext addConfigurations(Map<String, String> configurations) {
        this.credential.addConfigurations(configurations);
        return this;
    }

    public APIContext addConfiguration(String key, String value) {
        this.credential.addConfiguration(key, value);
        return this;
    }

    public String getConfiguration(String key) {
        return this.credential.getConfiguration(key);
    }

    public String getAccessToken() {
        try {
            return this.fetchAccessToken();
        }
        catch (PayPalRESTException ex) {
            return null;
        }
    }

    public String fetchAccessToken() throws PayPalRESTException {
        if (this.credential != null) {
            return this.credential.getAccessToken();
        }
        return null;
    }

    public String getRequestId() {
        String reqId = null;
        if (!this.maskRequestId) {
            if (this.requestId == null || this.requestId.length() <= 0) {
                this.requestId = UUID.randomUUID().toString();
            }
            reqId = this.requestId;
        }
        return reqId;
    }

    public APIContext setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public void setMaskRequestId(boolean maskRequestId) {
        this.maskRequestId = maskRequestId;
    }

    public SDKVersion getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(SDKVersion sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public Map<String, String> getHeadersMap() {
        return this.getHTTPHeaders();
    }

    public void setHeadersMap(Map<String, String> headersMap) {
        this.setHTTPHeaders(headersMap);
    }

    public String getClientID() {
        if (this.credential == null) {
            throw new IllegalArgumentException("ClientID and Secret are required. Please use APIContext(String clientID, String clientSecret, String mode)");
        }
        return this.credential.getClientID();
    }

    public String getClientSecret() {
        if (this.credential == null) {
            throw new IllegalArgumentException("ClientID and Secret are required. Please use APIContext(String clientID, String clientSecret, String mode)");
        }
        return this.credential.getClientSecret();
    }
}

