package com.pcauto.lib.autopocket;

import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.providers.CacheException;
import org.apache.ibatis.cache.Cache;
import org.springframework.util.CollectionUtils;

import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;


public class MybatisMcCache implements Cache {

    /**
     * 在 <cache />声明时，此类不归Spring管理，需要用静态注入
     * （用另一个Spring管理的bean来设置cache属性)
     */
    private static com.google.code.ssm.Cache cache;

    public static void setCache(com.google.code.ssm.Cache cache) {
        MybatisMcCache.cache = cache;
    }

    // 读写锁
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);

    private String id = "com.google.code.ssm.Cache.mybatis";

    public MybatisMcCache(final String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void putObject(Object key, Object value) {
        try {
            cache.add(key.toString(), 0, value, SerializationType.JSON);
        } catch (TimeoutException | CacheException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getObject(Object key) {
        try {
            return cache.get(key.toString(), SerializationType.JSON);
        } catch (TimeoutException | CacheException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Object removeObject(Object key) {
        try {
            return cache.delete(key.toString());
        } catch (TimeoutException | CacheException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void clear() {
        Set<String> keys = makeKeys("*:" + this.id + "*");
        if (!CollectionUtils.isEmpty(keys)) {
            try {
                cache.delete(keys);
            } catch (TimeoutException | CacheException e) {
                e.printStackTrace();
            }
        }


    }

    private Set<String> makeKeys(String s) {
        return null;
    }

    @Override
    public int getSize() {
        cache.getNativeClient();
        return 0;// size.intValue();
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}
