/**
 * Copyright 2009-2019 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.pcauto.lib.mybatis.keygen;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * 用于拦截MybatisPlus的Insert，加上维护gl_keygen的功能
 *
 * @author henry
 */
public class CustomAroundGenerator implements KeyGenerator {

    private KeyGenerator selectKeyGenerator;

    private final MappedStatement keyStatement;

    public CustomAroundGenerator(KeyGenerator selectKeyGenerator, MappedStatement keyStatement) {
        this.selectKeyGenerator = selectKeyGenerator;
        this.keyStatement = keyStatement;
    }


    @Override
    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        selectKeyGenerator.processBefore(executor, ms, stmt, parameter);
        doTheHook(executor, ms, stmt, parameter);
    }

    protected void doTheHook(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        // 必须在insert前先把gl_keygen的key更新了，宁可放过不可出错
        try {
            //Map<String,Object> params=new HashMap<>();
            //params.put("1",getObjectId(parameter));
            executor.update(keyStatement, parameter);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /**
     * @deprecated
     * @param object
     * @return
     */
    private Long getObjectId(Object object) {
        Long value = 1L;
        Class objClass = object.getClass();
        try {
            Method method = objClass.getDeclaredMethod("getId", null);
            Object objValue = method.invoke(object);

            if (objValue instanceof Number) {
                value = ((Number) objValue).longValue();
            } else {
                throw new RuntimeException("only support number id");
            }
        } catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        selectKeyGenerator.processAfter(executor, ms, stmt, parameter);
    }

}
