package com.pcauto.lib.mybatis.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel("省份信息,不带城市信息")
@Data
public class CityVO {
    @ApiModelProperty("省份id")
    private Integer provinceId;

    @ApiModelProperty("省份名")
    private String provinceName;

    @Data
    @ApiModel("省份信息(带城市信息)")
    public static class CityVOWithRegion{
        @ApiModelProperty("省份id")
        private Long provinceId;

        @ApiModelProperty("省份名")
        private String provinceName;

        @ApiModelProperty("省份管辖的城市")
        private List<Region> regionList;
    }

    @ApiModel("地级市信息")
    @Data
    public static class Region {
        @ApiModelProperty("城市id")
        private Long regionId;

        @ApiModelProperty("城市名称")
        private String regionName;

//        @ApiModelProperty("城市管辖的地区")
//        private List<Area> regionList;
    }

    @ApiModel("城区信息")
    @Data
    public static class Area {
        @ApiModelProperty("地区id")
        private Integer areaId;

        @ApiModelProperty("地区名称")
        private String areaName;
    }
}
