/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.autopocket;

import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.providers.CacheException;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.springframework.util.CollectionUtils;

public class MybatisMcCache
implements Cache {
    private static com.google.code.ssm.Cache cache;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private String id = "com.google.code.ssm.Cache.mybatis";

    public static void setCache(com.google.code.ssm.Cache cache) {
        MybatisMcCache.cache = cache;
    }

    public MybatisMcCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        try {
            cache.add(key.toString(), 0, value, SerializationType.JSON);
        }
        catch (CacheException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    public Object getObject(Object key) {
        try {
            return cache.get(key.toString(), SerializationType.JSON);
        }
        catch (CacheException | TimeoutException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object removeObject(Object key) {
        try {
            return cache.delete(key.toString());
        }
        catch (CacheException | TimeoutException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void clear() {
        Set<String> keys = this.makeKeys("*:" + this.id + "*");
        if (!CollectionUtils.isEmpty(keys)) {
            try {
                cache.delete(keys);
            }
            catch (CacheException | TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    private Set<String> makeKeys(String s) {
        return null;
    }

    public int getSize() {
        cache.getNativeClient();
        return 0;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }
}

