/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.mybatis.keygen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;

public class CustomAroundGenerator
implements KeyGenerator {
    private KeyGenerator selectKeyGenerator;
    private final MappedStatement keyStatement;

    public CustomAroundGenerator(KeyGenerator selectKeyGenerator, MappedStatement keyStatement) {
        this.selectKeyGenerator = selectKeyGenerator;
        this.keyStatement = keyStatement;
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        this.selectKeyGenerator.processBefore(executor, ms, stmt, parameter);
        this.doTheHook(executor, ms, stmt, parameter);
    }

    protected void doTheHook(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        try {
            executor.update(this.keyStatement, parameter);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Long getObjectId(Object object) {
        Long value = 1L;
        Class<?> objClass = object.getClass();
        try {
            Method method = objClass.getDeclaredMethod("getId", null);
            Object objValue = method.invoke(object, new Object[0]);
            if (!(objValue instanceof Number)) {
                throw new RuntimeException("only support number id");
            }
            value = ((Number)objValue).longValue();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        this.selectKeyGenerator.processAfter(executor, ms, stmt, parameter);
    }
}

