/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.mybatis.keygen;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.pcauto.lib.mybatis.keygen.IdGeneratorByTable;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

public class GlKeyGenerator
implements KeyGenerator {
    private TableInfo tableInfo;
    private IdGeneratorByTable idGenerator = new IdGeneratorByTable();
    private boolean executeBefore;

    public GlKeyGenerator(TableInfo tableInfo, boolean executeBefore) {
        this.tableInfo = tableInfo;
        this.executeBefore = executeBefore;
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (this.executeBefore) {
            this.processGeneratedKeys(executor, ms, parameter);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (!this.executeBefore) {
            this.processGeneratedKeys(executor, ms, parameter);
        }
    }

    private void processGeneratedKeys(Executor executor, MappedStatement ms, Object parameter) {
        try {
            executor.getTransaction().getConnection();
            Configuration configuration = ms.getConfiguration();
            String property = "id";
            String keySequence = this.tableInfo.getKeySequence().value();
            if (parameter != null) {
                MetaObject metaParam = configuration.newMetaObject(parameter);
                Connection conn = executor.getTransaction().getConnection();
                this.setValue(metaParam, property, this.idGenerator.generate(conn, keySequence, property));
            }
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException("Error selecting key or setting result to parameter object. Cause: " + e, (Throwable)e);
        }
    }

    private void setValue(MetaObject metaParam, String property, Object value) {
        if (!metaParam.hasSetter(property)) {
            throw new ExecutorException("No setter found for the keyProperty '" + property + "' in " + metaParam.getOriginalObject().getClass().getName() + ".");
        }
        metaParam.setValue(property, value);
    }
}

