/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.bridge.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pcauto.lib.bridge.client.BridgeApi;
import com.pcauto.lib.bridge.client.BridgeApi4Automan;
import com.pcauto.lib.bridge.client.BridgeProps;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@EnableConfigurationProperties(value={BridgeProps.class})
public class BridgeConfig {
    @Autowired
    BridgeProps bridgeProps;

    @Bean
    BridgeApi bridgeApi() {
        return this.getBridgeApi(this.bridgeProps.getUrl(), BridgeApi.class);
    }

    @Bean
    @ConditionalOnProperty(prefix="bridge", value={"fawvwUrl"})
    BridgeApi4Automan BridgeApi4Automan() {
        return this.getBridgeApi(this.bridgeProps.getFawvwUrl(), BridgeApi4Automan.class);
    }

    private <T> T getBridgeApi(String url, Class<T> bridgeClasss) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        Retrofit retrofit = new Retrofit.Builder().baseUrl(url).client(this.okHttpClient()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
        return (T)retrofit.create(bridgeClasss);
    }

    private OkHttpClient okHttpClient() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder().addInterceptor(this.customInterceptor()).addInterceptor((Interceptor)loggingInterceptor).build();
    }

    private Interceptor customInterceptor() {
        return chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            return response;
        };
    }
}

