package ${basePackage}.admin.controller;

import lombok.extern.slf4j.Slf4j;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@AutoConfigureMockMvc
//@AutoConfigureRestDocs("target/generated-snippets")
public class ${entityName}ControllerTest {
    @Autowired
    private WebApplicationContext wac;

    private MockMvc mockMvc;

    @Before
    public void setUp(){
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    /**
     * 新增测试用例
     * @throws Exception
     */
    @Test
    public void createTest() throws Exception {
        String json="";//虚拟${entityName}的数据
        mockMvc.perform(MockMvcRequestBuilders.post("/${entityName?uncap_first}")
                   .accept(MediaType.APPLICATION_JSON_UTF8)
                    .content(json.getBytes()) //传json参数
            )
           .andExpect(MockMvcResultMatchers.status().isOk())
           .andDo(MockMvcResultHandlers.print());
    }
    /**
     * 获取测试用例
     * @throws Exception
     */
    @Test
    public void qryTest() throws Exception {
        mockMvc.perform(MockMvcRequestBuilders.get("/${entityName?uncap_first}/1")
                    .contentType(MediaType.APPLICATION_JSON_UTF8)
                    .accept(MediaType.APPLICATION_JSON_UTF8)
            )
           .andExpect(MockMvcResultMatchers.status().isOk())
           .andExpect(MockMvcResultMatchers.jsonPath("").value("")) //jsonPath里面传入字段名称 如 $.username value 填入对应的值
          // .andExpect(MockMvcResultMatchers.jsonPath("").value(""))
           .andDo(MockMvcResultHandlers.print());
    }

    /**
     * 修改测试用例
     * @throws Exception
     */
    @Test
    public void updateTest() throws Exception{
        String json=" ";
        mockMvc.perform(MockMvcRequestBuilders.put("/${entityName?uncap_first}/1")
                .accept(MediaType.APPLICATION_JSON_UTF8)
                .content(json.getBytes())//传json参数
        )
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andDo(MockMvcResultHandlers.print());
    }

    /**
     * 删除教程测试用例
     * @throws Exception
     */
    @Test
    public void deleteTest() throws Exception{
        mockMvc.perform(MockMvcRequestBuilders.delete("/${entityName?uncap_first}/1")
                .accept(MediaType.APPLICATION_JSON_UTF8)
        )
                .andExpect(MockMvcResultMatchers.status().isOk())
                .andDo(MockMvcResultHandlers.print());
    }
}
