/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.codegen.genner;

import com.pcauto.lib.codegen.genner.DataModel;
import com.pcauto.lib.codegen.genner.TmplFileInfo;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JpaCodeGenner {
    public static final String TEST = "Test";
    public static final String ENTITY = "Entity";
    private Configuration cfg = new Configuration(Configuration.getVersion());

    private void initConfig(String tmplPackage) {
        this.cfg.setClassForTemplateLoading(this.getClass(), tmplPackage);
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(true);
    }

    public void gen(String tmplPackage, DataModel dataModel, File baseOutput) {
        this.initConfig(tmplPackage);
        List<TmplFileInfo> tmplFileList = this.collectTemplates(tmplPackage, tmplPackage);
        String input = this.getInput(tmplFileList);
        tmplFileList.stream().filter(tmplFileInfo -> input.contains(tmplFileInfo.getShortCode())).forEach(tmplFileInfo -> this.internalGen((TmplFileInfo)tmplFileInfo, dataModel, baseOutput));
    }

    private void internalGen(TmplFileInfo tmplFileInfo, DataModel data, File baseOutput) {
        String newPath = data.getBasePackage().replaceAll("\\.", "/") + "/" + tmplFileInfo.getTemplate().replaceAll("(.*)/([^\\.]*)\\.([^\\.]*).ftl$", "$1/" + data.getEntityName() + "$2.$3").replaceAll(ENTITY, "");
        try {
            Template temp = this.cfg.getTemplate(tmplFileInfo.getTemplate());
            String javaOut = baseOutput.getPath() + "/src/main/java";
            String testOut = baseOutput.getPath() + "/src/test/java";
            String prefixPath = newPath.endsWith("Test.java") ? testOut : javaOut;
            File outFile = new File(prefixPath + "/" + newPath);
            if (!outFile.getParentFile().isDirectory()) {
                outFile.getParentFile().mkdirs();
            }
            FileWriter fileWriter = new FileWriter(outFile);
            temp.process((Object)data, (Writer)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
    }

    private String getInput(List<TmplFileInfo> tmplList) {
        List templates = tmplList.stream().map(TmplFileInfo::getTemplate).filter(s -> !s.contains(TEST)).map(s -> s.substring(s.lastIndexOf("/") + 1, s.indexOf("."))).collect(Collectors.toList());
        System.out.println("\u8f93\u5165\u9700\u8981\u751f\u6210\u7684\u7c7b(\u9996\u5b57\u6bcd):\u5982erscvm");
        System.out.println(templates);
        Scanner scan = new Scanner(System.in);
        String read = scan.nextLine();
        return read;
    }

    private List<TmplFileInfo> collectTemplates(String tmplPackage, String rootPackage) {
        ArrayList<TmplFileInfo> collected = new ArrayList<TmplFileInfo>();
        try (Stream<Path> paths = Files.list(Paths.get(JpaCodeGenner.class.getResource(tmplPackage).toURI()));){
            paths.forEach(path -> {
                File file = path.toFile();
                if (file.isDirectory()) {
                    collected.addAll(this.collectTemplates(tmplPackage + "/" + file.getName(), rootPackage));
                } else if (file.getName().endsWith(".ftl")) {
                    collected.add(new TmplFileInfo((Path)path, rootPackage));
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return collected;
    }
}

