package ${basePackage}.service;

import ${basePackage}.domain.${entityName};
import ${basePackage}.mapper.${entityName}Mapper;
import ${basePackage}.repository.${entityName}Repository;
import ${basePackage}.dto.${entityName}Dto;
import com.pcauto.lib.discuss.PageUtil;
import com.pcauto.lib.core.mvc.pager.PageVo;
import com.pcauto.lib.core.mvc.pager.PageDto;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;

import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
/**
 * @author Wad Generator
 */
@Service
@Transactional
@AllArgsConstructor
public class ${entityName}Service {

    ${entityName}Repository ${entityName?uncap_first}Repository;

    public PageVo<${entityName}Dto.Vo> searchPage(PageDto pageDto, ${entityName}Dto.SearchCriteria criteria) {
        Example<${entityName}> example = Example.of(${entityName}Mapper.INSTANCE.criteriaToExample(criteria));
        example.getMatcher().withIgnoreNullValues();

        Page<${entityName}Dto.Vo> voPage = ${entityName?uncap_first}Repository.findAll(PageUtil.toPageable(pageDto))
        .map(entity -> ${entityName}Mapper.INSTANCE.entityToVo(entity));
        return PageUtil.toPageVo(voPage);
    }

    public void save(${entityName}Dto.CreateDto ${entityName?uncap_first}) {
        ${entityName} e = ${entityName}Mapper.INSTANCE.createDtoToEntity(${entityName?uncap_first});
        ${entityName?uncap_first}Repository.save(e);
    }

    public ${entityName}Dto.VoX findById(Long id) {
        ${entityName} e = ${entityName?uncap_first}Repository.findById(id).get();
        return ${entityName}Mapper.INSTANCE.entityToVoX(e);
    }

    public void update(Long id, ${entityName}Dto.UpdateDto ${entityName?uncap_first}) {
        ${entityName?uncap_first}.setId(id);
        ${entityName} e = ${entityName}Mapper.INSTANCE.updateDtoToEntity(${entityName?uncap_first});
        ${entityName?uncap_first}Repository.save(e);
    }

    public void delete(Long id) {
        ${entityName?uncap_first}Repository.deleteById(id);
    }
}
