package com.pcauto.lib.codegen.genner;

import lombok.Data;

import java.io.File;
import java.nio.file.Path;

@Data
public class TmplFileInfo {
    private String template;
    private String shortCode;

    public TmplFileInfo(Path path, String rootPackage) {
        File file = path.toFile();
        String fileName = file.getName().replaceAll("\\..*", "");
        this.shortCode = fileName.substring(0,1).toLowerCase();

        this.template = path.toString();
        String os = System.getProperty("os.name");
        //window路径问题
        if(os.toLowerCase().startsWith("win")){
            this.template=this.template.replaceAll("\\\\","/");
        }
        int index=this.template.indexOf(rootPackage);
        this.template = this.template.substring(index+rootPackage.length());
    }
}
