<#assign camelEntity="${entityName?uncap_first}"/>
package ${basePackage}.admin.controller;
import com.pcauto.lib.core.mvc.pager.PageVo;
import com.pcauto.lib.core.mvc.pager.PageDto;

import ${basePackage}.domain.${entityName};
import ${basePackage}.dto.${entityName}Dto;
import ${basePackage}.service.${entityName}Service;
import io.swagger.annotations.*;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
/**
 * @author Wad Generator
 */
@Api(value = "${entityName}", description = "${entityName}", tags = "${entityName}")
@RestController
@AllArgsConstructor
public class ${entityName}Controller {

    ${entityName}Service ${camelEntity}Service;

    @ApiOperation(value = "list", notes = "${entityName} 列表查询")
    @GetMapping("/${camelEntity}")
    public PageVo<${entityName}Dto.Vo> list${entityName}(PageDto pageDto, ${entityName}Dto.SearchCriteria criteria ) {
        return ${camelEntity}Service.searchPage(pageDto,criteria);
    }

    @ApiOperation(value = "create", notes = "创建实体${entityName}" )
    @PostMapping("/${camelEntity}")
    public void create${entityName}(@RequestBody @Validated ${entityName}Dto.CreateDto create${entityName}Dto) {
        ${camelEntity}Service.save(create${entityName}Dto);
    }

    @ApiOperation(value = "getOne", notes = "根据Id获取${entityName}详情" )
    @GetMapping("/${camelEntity}/{id}")
    public ${entityName}Dto.VoX get${entityName}(@PathVariable Long id) {
        return ${camelEntity}Service.findById(id);
    }

    @ApiOperation(value = "update", notes = "整体更新${entityName}" )
    @PutMapping("/${camelEntity}/{id}")
    public void update${entityName}(@PathVariable Long id,
        @RequestBody @Validated ${entityName}Dto.UpdateDto update${entityName}Dto) {
        ${camelEntity}Service.update(id,update${entityName}Dto);
    }

    // 可定义多个patch
    @ApiOperation(value = "patch", notes = "${entityName}单个属性修改")
    @PatchMapping("/${camelEntity}/{id}")
    public void patch${entityName}() {
        // ${camelEntity}Service.update(id,${camelEntity});
    }


    @ApiOperation(value = "delete", notes = "按Id删除${entityName}" )
    @DeleteMapping("/${camelEntity}/{id}")
    public void delete${entityName}(@PathVariable Long id) {
        // 默认不开启delete
        // ${camelEntity}Service.delete(id);
    }

    // 在下面添加自定义的接口 [注意参考文档关于Controller的说明]
}