package ${basePackage}.dto;

import ${basePackage}.domain.${entityName};
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
/**
 * @author Wad Generator
 * 因为产生大量类似的类，为方便管理，使用静态内部类
 * https://github.com/mapstruct/mapstruct/issues/411
 */
public class ${entityName}Dto {

    // /* 下面用单行注释，为了快速开启或关闭某个子Vo,默认继承domain，一般需要修改
    ///////////////////////////////////////////////////////////////////////

    // 搜索请求
    @Data//@Builder
    @ApiModel(value="${entityName}.SearchCriteria", description = "${entityName} 列表筛选条件")
    static public class SearchCriteria {
    }

    // 详情
    @Data//@Builder
    @ApiModel(value="${entityName}.Vo", description = "${entityName} 实体Vo,部分属性")
    static public class Vo extends ${entityName} {
        // @ApiModelProperty(value = "id")
        // private Long id;
    }

    // 扩展(包含其他对象引用)
    @Data//@Builder
    @ApiModel(value="${entityName}.VoX", description = "${entityName} 实体详情+全部或扩展属性")
    static public class VoX extends Vo {
        // @ApiModelProperty(value = "id")
        // private Long id;
    }

    ///////////////////////////////////////////////////////////////////////

    // 创建实体的Dto
    @Data//@Builder
    @ApiModel(value="${entityName}.CreateDto", description = "创建实体${entityName} 的Dto")
    static public class CreateDto extends Vo {
    }

    // 更新实体的Dto
    @Data//@Builder
    @ApiModel(value="${entityName}.UpdateDto", description = "更新实体${entityName} 的Dto，带id")
    static public class UpdateDto extends Vo {
        // @ApiModelProperty(value = "id")
        // private Long id;
    }
    //*/

    ///////////////////后面放自定义的Dto/Vo 方便版本比较///////////////////////
}

