package ${basePackage}.service;

import ${basePackage}.domain.${entityName};
import ${basePackage}.mapper.${entityName}Mapper;
import ${basePackage}.vo.${entityName}Vo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

import javax.transaction.Transactional;
/**
 * @author Wad Generator
 */
@Service
@Transactional
@AllArgsConstructor
public class ${entityName}Service {

    ${entityName}Mapper ${entityName?uncap_first}Mapper;

  public ${entityName} selectByKey(Object key) {
        //说明：根据主键字段进行查询，方法参数必须包含完整的主键属性，查询条件使用等号
        return ${entityName?uncap_first}Mapper.selectByPrimaryKey(key);
    }

    public int save(${entityName} entity) {
        //说明：保存一个实体，null的属性也会保存，不会使用数据库默认值
        return ${entityName?uncap_first}Mapper.insert(entity);
    }

    public int delete(Object key) {
        //说明：根据主键字段进行删除，方法参数必须包含完整的主键属性
        return ${entityName?uncap_first}Mapper.deleteByPrimaryKey(key);
    }

    public int updateAll(${entityName} entity) {
        //说明：根据主键更新实体全部字段，null值会被更新
        return ${entityName?uncap_first}Mapper.updateByPrimaryKey(entity);
    }

    public int updateNotNull(${entityName} entity) {
        //根据主键更新属性不为null的值
        return ${entityName?uncap_first}Mapper.updateByPrimaryKeySelective(entity);
    }

    public List<${entityName}> selectByExample(Object example) {
    //说明：根据Example条件进行查询
    //重点：这个查询支持通过Example类指定查询列，通过selectProperties方法指定查询列
    return ${entityName?uncap_first}Mapper.selectByExample(example);
    }
}
