/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.discuss.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pcauto.lib.discuss.api.DiscussApi;
import com.pcauto.lib.discuss.config.DiscussProperties;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@EnableConfigurationProperties(value={DiscussProperties.class})
public class DiscussApiConfig {
    @Autowired
    private DiscussProperties discussProperties;

    @Bean
    DiscussApi discussApi() {
        if (this.discussProperties == null || StringUtils.isEmpty((Object)this.discussProperties.getAppid())) {
            throw new RuntimeException("=============>>> \u5927\u54e5,\u4f60\u5fd8\u8bb0\u914d\u7f6eDiscuss\u7684appid\u4e86 <<<=============");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.discussProperties.getHost()).client(this.okHttpClient()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)new ObjectMapper())).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
        return (DiscussApi)retrofit.create(DiscussApi.class);
    }

    private OkHttpClient okHttpClient() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).build();
    }
}

