/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.discuss.service;

import com.pcauto.lib.discuss.api.DiscussApi;
import com.pcauto.lib.discuss.api.DiscussResponse;
import com.pcauto.lib.discuss.config.DiscussProperties;
import com.pcauto.lib.discuss.error.DiscussException;
import com.pcauto.lib.discuss.pojo.DiscussComment;
import com.pcauto.lib.discuss.pojo.DiscussCommentResult;
import com.pcauto.lib.discuss.pojo.DiscussCommentSearchMap;
import com.pcauto.lib.discuss.pojo.DiscussCommentSearchResult;
import com.pcauto.lib.discuss.pojo.DiscussPageResult;
import com.pcauto.lib.discuss.pojo.DiscussUser;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import retrofit2.Call;

@Service
public class DiscussService {
    public static final Logger LOGGER = LoggerFactory.getLogger(DiscussService.class);
    @Autowired
    private DiscussProperties discussProperties;
    @Autowired
    private DiscussApi discussApi;

    public void saveOrUpdate(DiscussUser discussUser) throws DiscussException {
        String appId = this.discussProperties.getAppid();
        if (StringUtils.isEmpty((Object)appId)) {
            throw new DiscussException("appId\u6ca1\u6709\u6b63\u786e\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)discussUser.getUserId())) {
            throw new DiscussException("userId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)discussUser.getUserName())) {
            throw new DiscussException("userName \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Call<DiscussResponse> call = this.discussApi.saveOrUpdate(appId, discussUser);
        this.checkResponse(call);
    }

    public void submitComment(DiscussComment commentDto) throws DiscussException {
        String appId = this.discussProperties.getAppid();
        if (StringUtils.isEmpty((Object)appId)) {
            throw new DiscussException("appId\u6ca1\u6709\u6b63\u786e\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)commentDto.getUserId())) {
            throw new DiscussException("userId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)commentDto.getKey())) {
            throw new DiscussException("\u8bc4\u8bba\u5f52\u5c5ekey \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)commentDto.getContent())) {
            throw new DiscussException("\u8bc4\u8bba\u5185\u5bb9 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Call<DiscussResponse> call = this.discussApi.submitComment(appId, commentDto);
        this.checkResponse(call);
    }

    public DiscussPageResult<DiscussCommentResult> pageComment(String key, String userId, Integer page, Integer pageSize) throws DiscussException {
        return this.pageComment(key, userId, "asc", page, pageSize);
    }

    public DiscussPageResult<DiscussCommentResult> pageComment(String key, String userId, String sort, Integer page, Integer pageSize) throws DiscussException {
        String appId = this.discussProperties.getAppid();
        if (StringUtils.isEmpty((Object)appId)) {
            throw new DiscussException("appId\u6ca1\u6709\u6b63\u786e\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)key)) {
            throw new DiscussException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)sort)) {
            sort = "asc";
        } else if (!"asc".equals(sort) && !"desc".equals(sort)) {
            throw new DiscussException("sort\u503c\u6709\u8bef,\u8bf7\u4f20\u5165asc\u6216desc");
        }
        Call<DiscussResponse<DiscussPageResult<DiscussCommentResult>>> call = this.discussApi.pageComment(appId, key, userId, sort, page, pageSize);
        try {
            DiscussResponse response = (DiscussResponse)call.execute().body();
            if (response.getCode() == 1) {
                return (DiscussPageResult)response.getData();
            }
            throw new DiscussException(response.getCode(), response.getMsg());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DiscussException(50000, "\u8bc4\u8bba\u670d\u52a1\u8bbf\u95ee\u5f02\u5e38");
        }
    }

    public DiscussPageResult<DiscussCommentSearchResult> searchComment(DiscussCommentSearchMap searchMap, Integer page, Integer pageSize) throws DiscussException {
        String appId = this.discussProperties.getAppid();
        if (StringUtils.isEmpty((Object)appId)) {
            throw new DiscussException("appId\u6ca1\u6709\u6b63\u786e\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)searchMap.getSort())) {
            searchMap.setSort("asc");
        } else if (!"asc".equals(searchMap.getSort()) && !"desc".equals(searchMap.getSort())) {
            throw new DiscussException("sort\u503c\u6709\u8bef,\u8bf7\u4f20\u5165asc\u6216desc");
        }
        Long startTime = searchMap.getStartTime() != null ? Long.valueOf(searchMap.getStartTime().getTime()) : null;
        Long endTime = searchMap.getEndTime() != null ? Long.valueOf(searchMap.getEndTime().getTime()) : null;
        Call<DiscussResponse<DiscussPageResult<DiscussCommentSearchResult>>> call = this.discussApi.searchComment(appId, searchMap.getKey(), searchMap.getContent(), searchMap.getUserIds(), searchMap.getUserName(), searchMap.getStatus(), startTime, endTime, searchMap.getSort(), page, pageSize);
        try {
            DiscussResponse response = (DiscussResponse)call.execute().body();
            if (response.getCode() == 1) {
                return (DiscussPageResult)response.getData();
            }
            throw new DiscussException(response.getCode(), response.getMsg());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DiscussException(50000, "\u8bc4\u8bba\u670d\u52a1\u8bbf\u95ee\u5f02\u5e38");
        }
    }

    public void updateCommentStatus(String commentId, int status) throws DiscussException {
        String appId = this.discussProperties.getAppid();
        if (StringUtils.isEmpty((Object)appId)) {
            throw new DiscussException("appId\u6ca1\u6709\u6b63\u786e\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)commentId)) {
            throw new DiscussException("\u8bc4\u8bbaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (status != 0 && status != 1) {
            throw new DiscussException("\u72b6\u6001\u503c\u9519\u8bef");
        }
        Call<DiscussResponse> call = this.discussApi.updateCommentStatus(appId, commentId, status);
        this.checkResponse(call);
    }

    public void deleteComment(String commentId) throws DiscussException {
        String appId = this.discussProperties.getAppid();
        if (StringUtils.isEmpty((Object)appId)) {
            throw new DiscussException("appId\u6ca1\u6709\u6b63\u786e\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)commentId)) {
            throw new DiscussException("\u8bc4\u8bbaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Call<DiscussResponse> call = this.discussApi.deleteComment(appId, commentId);
        this.checkResponse(call);
    }

    public long getCommentCount(String key, Integer status, Date startTime, Date endTime) throws DiscussException {
        String appId = this.discussProperties.getAppid();
        if (StringUtils.isEmpty((Object)appId)) {
            throw new RuntimeException("appId\u6ca1\u6709\u6b63\u786e\u914d\u7f6e");
        }
        Long startTime_ = startTime != null ? Long.valueOf(startTime.getTime()) : null;
        Long endTime_ = endTime != null ? Long.valueOf(endTime.getTime()) : null;
        Call<DiscussResponse<Long>> call = this.discussApi.getCommentCount(appId, key, status, startTime_, endTime_);
        try {
            DiscussResponse response = (DiscussResponse)call.execute().body();
            if (response.getCode() == 1) {
                return (Long)response.getData();
            }
            throw new DiscussException(response.getCode(), response.getMsg());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DiscussException(50000, "\u8bc4\u8bba\u670d\u52a1\u8bbf\u95ee\u5f02\u5e38");
        }
    }

    private void checkResponse(Call<DiscussResponse> call) throws DiscussException {
        try {
            DiscussResponse response = (DiscussResponse)call.execute().body();
            if (response.getCode() != 1) {
                throw new DiscussException(response.getCode(), response.getMsg());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DiscussException(50000, "\u8bc4\u8bba\u670d\u52a1\u8bbf\u95ee\u5f02\u5e38");
        }
    }
}

