package com.pcauto.lib.discuss.api;

import lombok.Data;

/**
 * @author Sam
 */
@Data
public class DiscussResponse<T> {

    public DiscussResponse() {
        this.code = 1;
        this.msg = "OK";
        this.data = null;
    }

    public DiscussResponse(T data) {
        this.code = 1;
        this.msg = "OK";
        this.data = data;
    }

    public DiscussResponse(String msg) {
        this.code = 0;
    }

    public DiscussResponse(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public DiscussResponse(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    private int code;

    private String msg;

    private T data;
}
