package com.pcauto.lib.discuss.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pcauto.lib.discuss.api.DiscussApi;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

/**
 * @author Sam
 */
@Configuration
@EnableConfigurationProperties(DiscussProperties.class)
public class DiscussApiConfig {

    @Autowired
    private DiscussProperties discussProperties;

    @Bean
    DiscussApi discussApi() {
        if (discussProperties == null || StringUtils.isEmpty(discussProperties.getAppid())) {
            throw new RuntimeException("=============>>> 大哥,你忘记配置Discuss的appid了 <<<=============");
        }
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(discussProperties.getHost())
                .client(okHttpClient())
                .addConverterFactory(JacksonConverterFactory.create(new ObjectMapper()))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .build();
        return retrofit.create(DiscussApi.class);
    }

    private OkHttpClient okHttpClient() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder()
                .addInterceptor(loggingInterceptor)
                .build();
    }

}
