package com.pcauto.lib.discuss.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 评论
 *
 * @author sam
 * @since 2019/8/13
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DiscussComment {

    /**
     * [必须] 用户id
     */
    private String userId;

    /**
     * [非必须] 用户昵称
     */
    private String userName;

    /**
     * [非必须] 用户头像
     */
    private String userAvatar;

    /**
     * [必须] 评论归属key 如：文章id、话题id等
     */
    private String key;

    /**
     * [必须] 评论内容
     */
    private String content;

    /**
     * (非必须) 被回复的评论id,回复时有值
     */
    private String beReplyId;

}
