package com.pcauto.lib.discuss.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 评论搜索请求map
 *
 * @author sam
 * @since 2019/8/13
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DiscussCommentSearchMap {

    /**
     * [非必须] 评论归属key 如：文章id、话题id等
     */
    private String key;

    /**
     * [非必须] 发表评论的用户id,多个则以逗号拼接 如: 1,2,3
     */
    private String userIds;

    /**
     * [非必须] 评论内容
     */
    private String content;

    /**
     * [非必须] 用户名
     */
    private String userName;

    /**
     * [非必须] 状态 0:被作废 1:正常
     */
    private Integer status;

    /**
     * [非必须] 查询时间范围：开始时间
     */
    private Date startTime;

    /**
     * [非必须] 查询时间范围：结束时间
     */
    private Date endTime;

    /**
     * [非必须] 排序 desc,asc 默认为:asc
     */
    private String sort;

}
