package com.pcauto.lib.discuss.api;

import com.pcauto.lib.discuss.pojo.*;
import retrofit2.Call;
import retrofit2.http.*;

import java.util.List;

/**
 * @author sam
 * @since 2019/8/8
 */
public interface DiscussApi {


    /**
     * 创建or更新用户信息
     *
     * @param appId
     * @param discussUserDto
     * @return
     */
    @POST("/api/discuss/{appId}/user")
    Call<DiscussResponse> saveOrUpdate(@Path("appId") String appId, @Body DiscussUser discussUserDto);

    /**
     * 发表评论、回复
     *
     * @param appId
     * @param discussCommentDto
     * @return
     */
    @POST("/api/discuss/{appId}/comment")
    Call<DiscussResponse> submitComment(@Path("appId") String appId, @Body DiscussComment discussCommentDto);

    /**
     * 获取某个key下的评论列表
     *
     * @param appId
     * @param key
     * @param userId
     * @param sort
     * @param page
     * @param pageSize
     * @return
     */
    @GET("/api/discuss/{appId}/comment")
    Call<DiscussResponse<DiscussPageResult<DiscussCommentResult>>> pageComment(@Path("appId") String appId,
                                                                               @Query("key") String key,
                                                                               @Query("userId") String userId,
                                                                               @Query("topSort") String topSort,
                                                                               @Query("sort") String sort,
                                                                               @Query("page") Integer page,
                                                                               @Query("pageSize") Integer pageSize);

    /**
     * 搜索查询评论列表（可用于后台管理）
     *
     * @param appId
     * @param key
     * @param content
     * @param userIds
     * @param userName
     * @param status
     * @param startTime
     * @param endTime
     * @param sort
     * @param page
     * @param pageSize
     * @return
     */
    @GET("/api/discuss/{appId}/comment/search")
    Call<DiscussResponse<DiscussPageResult<DiscussCommentSearchResult>>> searchComment(@Path("appId") String appId,
                                                                                       @Query("key") String key,
                                                                                       @Query("content") String content,
                                                                                       @Query("userIds") String userIds,
                                                                                       @Query("userName") String userName,
                                                                                       @Query("status") Integer status,
                                                                                       @Query("startTime") Long startTime,
                                                                                       @Query("endTime") Long endTime,
                                                                                       @Query("sort") String sort,
                                                                                       @Query("top") Integer top,
                                                                                       @Query("page") Integer page,
                                                                                       @Query("pageSize") Integer pageSize);

    /**
     * 修改评论状态
     *
     * @param appId
     * @param commentId
     * @param status
     * @return
     */
    @PUT("/api/discuss/{appId}/comment/{commentId}/status/{status}")
    Call<DiscussResponse> updateCommentStatus(@Path("appId") String appId, @Path("commentId") String commentId, @Path("status") int status);

    /**
     * 置顶评论
     *
     * @param appId
     * @param commentId
     * @return
     */
    @PUT("/api/discuss/{appId}/comment/{commentId}/top")
    Call<DiscussResponse> topComment(@Path("appId") String appId, @Path("commentId") String commentId);

    /**
     * 取消置顶评论
     *
     * @param appId
     * @param commentId
     * @return
     */
    @PUT("/api/discuss/{appId}/comment/{commentId}/top/cancel")
    Call<DiscussResponse> cancelTopComment(@Path("appId") String appId, @Path("commentId") String commentId);

    /**
     * 删除评论
     *
     * @param appId
     * @param commentId
     * @return
     */
    @DELETE("/api/discuss/{appId}/comment/{commentId}")
    Call<DiscussResponse> deleteComment(@Path("appId") String appId, @Path("commentId") String commentId);

    /**
     * 对评论点赞
     *
     * @param appId
     * @param commentId
     * @return
     */
    @POST("/api/discuss/{appId}/comment/{commentId}/like")
    Call<DiscussResponse> likeComment(@Path("appId") String appId, @Path("commentId") String commentId);

    /**
     * 统计评论数
     *
     * @param appId
     * @param key
     * @param status
     * @param startTime
     * @param endTime
     * @return
     */
    @GET("/api/discuss/{appId}/tj/comment/count")
    Call<DiscussResponse<Long>> getCommentCount(@Path("appId") String appId, @Query("key") String key, @Query("status") Integer status,
                                                @Query("startTime") Long startTime, @Query("endTime") Long endTime);

    /**
     * 统计多个文章各自的评论人数
     *
     * @param appId
     * @param key
     * @return
     */
    @POST("/api/discuss/{appId}/tj/comment/mulUserCount")
    Call<DiscussResponse<List<DiscussCommentUserCountResult>>> getCommentUserCountByKeys(@Path("appId") String appId, @Body List<String> key);

}
