package com.pcauto.lib.discuss.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 评论
 *
 * @author sam
 * @since 2019/8/13
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DiscussCommentResult {

    /**
     * 评论id
     */
    private String id;

    /**
     * 发表评论或回复的用户
     */
    private DiscussUserResult user;

    /**
     * 评论内容
     */
    private String content;

    /**
     * 被回复的评论id
     */
    private String beReplyId;

    /**
     * 被回复的用户 (回复时有值)
     */
    private DiscussUserResult beReplyUser;

    /**
     * 状态 0:被作废 1:正常
     */
    private int status;

    /**
     * 评论、回复时间
     */
    private Date createTime;

    /**
     * 是否点赞
     */
    private boolean like;

    /**
     * 是否置顶
     */
    private boolean top;
}
