package com.pcauto.lib.discuss.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Sam
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DiscussPageResult<T> implements Serializable {

    /**
     * 响应码
     */
    private int code = 1;

    /**
     * 响应消息
     */
    private String msg = "OK";

    /**
     * 每页显示数量
     */
    private Integer pageSize;

    /**
     * 当前页
     */
    private Integer page;

    /**
     * 总记录数
     */
    private Long total;

    /**
     * 数据列表
     */
    private List<T> rows;

}
