/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.credits.sdk;

import cn.com.duiba.credits.sdk.SignTool;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CreditNotifyParams {
    private boolean success;
    private String bizId = "";
    private String errorMessage = "";
    private String orderNum = "";
    private Date timestamp = new Date();
    private String appKey;
    private String uid = "";
    private String transfer = "";

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Map<String, String> toRequestMap(String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("success", this.success + "");
        map.put("errorMessage", this.getString(this.errorMessage));
        map.put("bizId", this.getString(this.bizId));
        map.put("appKey", this.getString(this.appKey));
        map.put("appSecret", this.getString(appSecret));
        this.putIfNotEmpty(map, "transfer", this.transfer);
        map.put("timestamp", this.getString(this.timestamp.getTime()));
        map.put("uid", this.getString(this.uid));
        map.put("orderNum", this.getString(this.orderNum));
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private void putIfNotEmpty(Map<String, String> map, String key, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        map.put(key, value);
    }

    private String getString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getTransfer() {
        return this.transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }
}

