/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.credits.sdk;

import cn.com.duiba.credits.sdk.AddCreditsParams;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.CreditAuditParams;
import cn.com.duiba.credits.sdk.CreditConfirmParams;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.credits.sdk.CreditNeedAuditParams;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.ExpressInfo;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.credits.sdk.VirtualCardConsumeParams;
import cn.com.duiba.credits.sdk.VirtualCardNotifyParams;
import cn.com.duiba.credits.sdk.VirtualParams;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CreditTool {
    private String appKey;
    private String appSecret;

    public CreditTool(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public String buildUrlWithSign(String url, Map<String, String> params) {
        HashMap<String, String> newparams = new HashMap<String, String>(params);
        newparams.put("appKey", this.appKey);
        newparams.put("appSecret", this.appSecret);
        if (newparams.get("timestamp") == null) {
            newparams.put("timestamp", System.currentTimeMillis() + "");
        }
        String sign = SignTool.sign(newparams);
        newparams.put("sign", sign);
        newparams.remove("appSecret");
        return AssembleTool.assembleUrl(url, newparams);
    }

    public String buildAutoLoginRequest(String uid, Long credits, String dbredirect) {
        String url = "https://home.m.duiba.com.cn/autoLogin/autologin?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", uid);
        params.put("credits", credits + "");
        if (dbredirect != null) {
            params.put("redirect", dbredirect);
        }
        String autologinUrl = this.buildUrlWithSign(url, params);
        return autologinUrl;
    }

    public String buildCreditOrderStatusRequest(String orderNum, String bizId) {
        if (orderNum == null) {
            orderNum = "";
        }
        if (bizId == null) {
            bizId = "";
        }
        String url = "http://www.duiba.com.cn/status/orderStatus?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderNum", orderNum);
        params.put("bizId", bizId);
        String buildUrl = this.buildUrlWithSign(url, params);
        return buildUrl;
    }

    public String buildCreditAuditRequest(CreditAuditParams params) {
        String s;
        String url = "http://www.duiba.com.cn/audit/apiAudit?";
        HashMap<String, String> signParams = new HashMap<String, String>();
        if (params.getPassOrderNums() != null && params.getPassOrderNums().size() > 0) {
            s = null;
            for (String o : params.getPassOrderNums()) {
                if (s == null) {
                    s = o;
                    continue;
                }
                s = s + "," + o;
            }
            signParams.put("passOrderNums", s);
        } else {
            signParams.put("passOrderNums", "");
        }
        if (params.getRejectOrderNums() != null && params.getRejectOrderNums().size() > 0) {
            s = null;
            for (String o : params.getRejectOrderNums()) {
                if (s == null) {
                    s = o;
                    continue;
                }
                s = s + "," + o;
            }
            signParams.put("rejectOrderNums", s);
        } else {
            signParams.put("rejectOrderNums", "");
        }
        String buildUrl = this.buildUrlWithSign(url, signParams);
        return buildUrl;
    }

    public String buildCreditConfirmRequest(CreditConfirmParams p) {
        String url = "http://www.duiba.com.cn/confirm/confirm?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("success", p.isSuccess() + "");
        params.put("errorMessage", p.getErrorMessage());
        params.put("orderNum", p.getOrderNum());
        String bulidurl = this.buildUrlWithSign(url, params);
        return bulidurl;
    }

    public String queryForFrontItem(String count) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("count", count);
        String url = this.buildUrlWithSign("http://www.duiba.com.cn/queryForFrontItem/query?", params);
        return url;
    }

    public String getActivityTimes(String uid, String activityId, String validType, String times, String bizId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", uid);
        params.put("bizId", bizId);
        params.put("activityId", activityId);
        params.put("validType", validType);
        params.put("times", times);
        String url = this.buildUrlWithSign("https://activity.m.duiba.com.cn/activityVist/addTimes?", params);
        return url;
    }

    public String batchCancel(List<String> orderNums) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderNums.size() > 100) {
            orderNums = orderNums.subList(0, 100);
        }
        StringBuffer orders = new StringBuffer();
        for (String orderNum : orderNums) {
            orders.append(orderNum).append(",");
        }
        params.put("orderNums", orders.deleteCharAt(orders.length() - 1).toString());
        String url = this.buildUrlWithSign("http://www.duiba.com.cn/sendObject/batchCancel?", params);
        return url;
    }

    public String batchSend(List<ExpressInfo> infos) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuffer expressInfo = new StringBuffer();
        if (infos.size() > 100) {
            infos = infos.subList(0, 100);
        }
        for (ExpressInfo info : infos) {
            expressInfo.append(info);
        }
        expressInfo.deleteCharAt(expressInfo.length() - 1);
        params.put("expressInfo", expressInfo.toString());
        String url = this.buildUrlWithSign("http://www.duiba.com.cn/sendObject/batchSend?", params);
        return url;
    }

    public CreditConsumeParams parseCreditConsume(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        CreditConsumeParams params = new CreditConsumeParams();
        params.setAppKey(this.appKey);
        params.setUid(request.getParameter("uid"));
        params.setCredits(Long.valueOf(request.getParameter("credits")));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setDescription(request.getParameter("description"));
        params.setOrderNum(request.getParameter("orderNum"));
        params.setType(request.getParameter("type"));
        if (request.getParameter("facePrice") != null) {
            params.setFacePrice(Integer.valueOf(request.getParameter("facePrice")));
        }
        if (request.getParameter("actualPrice") != null) {
            params.setActualPrice(Integer.valueOf(request.getParameter("actualPrice")));
        }
        if (request.getParameter("itemCode") != null) {
            params.setItemCode(request.getParameter("itemCode"));
        }
        params.setAlipay(request.getParameter("alipay"));
        params.setPhone(request.getParameter("phone"));
        params.setQq(request.getParameter("qq"));
        if (request.getParameter("waitAudit") != null) {
            params.setWaitAudit(Boolean.valueOf(request.getParameter("waitAudit")));
        }
        params.setIp(request.getParameter("ip"));
        params.setParams(request.getParameter("params"));
        if (request.getParameter("transfer") != null) {
            params.setTransfer(request.getParameter("transfer"));
        }
        return params;
    }

    public CreditNotifyParams parseCreditNotify(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        CreditNotifyParams params = new CreditNotifyParams();
        params.setSuccess(Boolean.valueOf(request.getParameter("success")));
        params.setErrorMessage(request.getParameter("errorMessage"));
        params.setBizId(request.getParameter("bizId"));
        params.setUid(request.getParameter("uid"));
        params.setAppKey(request.getParameter("appKey"));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setOrderNum(request.getParameter("orderNum"));
        if (request.getParameter("transfer") != null) {
            params.setTransfer(request.getParameter("transfer"));
        }
        return params;
    }

    public CreditNeedAuditParams parseCreditAudit(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        CreditNeedAuditParams params = new CreditNeedAuditParams();
        params.setAppKey(this.appKey);
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setBizId(request.getParameter("bizId"));
        return params;
    }

    public VirtualParams virtualConsume(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        VirtualParams params = new VirtualParams();
        params.setAppKey(this.appKey);
        params.setUid(request.getParameter("uid"));
        params.setDevelopBizId(request.getParameter("developBizId"));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setDescription(request.getParameter("description"));
        params.setOrderNum(request.getParameter("orderNum"));
        if (request.getParameter("account") != null) {
            params.setAccount(request.getParameter("account"));
        }
        params.setParams(request.getParameter("params"));
        if (request.getParameter("transfer") != null) {
            params.setTransfer(request.getParameter("transfer"));
        }
        return params;
    }

    public AddCreditsParams parseaddCredits(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        AddCreditsParams params = new AddCreditsParams();
        params.setAppKey(this.appKey);
        params.setUid(request.getParameter("uid"));
        params.setCredits(Long.valueOf(request.getParameter("credits")));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setDescription(request.getParameter("description"));
        params.setOrderNum(request.getParameter("orderNum"));
        params.setType(request.getParameter("type"));
        if (request.getParameter("transfer") != null) {
            params.setTransfer(request.getParameter("transfer"));
        }
        return params;
    }

    public VirtualCardConsumeParams parseVirtualCardConsume(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        VirtualCardConsumeParams params = new VirtualCardConsumeParams();
        params.setAppKey(this.appKey);
        params.setUid(request.getParameter("uid"));
        params.setCount(Long.valueOf(request.getParameter("count")));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setDescription(request.getParameter("description"));
        params.setOrderNum(request.getParameter("orderNum"));
        params.setType(request.getParameter("type"));
        if (request.getParameter("waitAudit") != null) {
            params.setWaitAudit(Boolean.valueOf(request.getParameter("waitAudit")));
        }
        params.setIp(request.getParameter("ip"));
        params.setParams(request.getParameter("params"));
        if (request.getParameter("transfer") != null) {
            params.setTransfer(request.getParameter("transfer"));
        }
        return params;
    }

    public VirtualCardNotifyParams parseVirtualCardNotify(HttpServletRequest request) throws Exception {
        if (!this.appKey.equals(request.getParameter("appKey"))) {
            throw new Exception("appKey\u4e0d\u5339\u914d");
        }
        if (request.getParameter("timestamp") == null) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26\u65f6\u95f4\u6233");
        }
        boolean verify = SignTool.signVerify(this.appSecret, request);
        if (!verify) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        VirtualCardNotifyParams params = new VirtualCardNotifyParams();
        params.setSuccess(Boolean.valueOf(request.getParameter("success")));
        params.setErrorMessage(request.getParameter("errorMessage"));
        params.setBizId(request.getParameter("bizId"));
        params.setUid(request.getParameter("uid"));
        params.setAppKey(request.getParameter("appKey"));
        params.setTimestamp(new Date(Long.valueOf(request.getParameter("timestamp"))));
        params.setOrderNum(request.getParameter("orderNum"));
        return params;
    }
}

