/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.credits.sdk;

import cn.com.duiba.credits.sdk.SignTool;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class VirtualParams {
    private String appKey;
    private Date timestamp;
    private Long credits;
    private String developBizId = "";
    private String uid = "";
    private String description = "";
    private String orderNum = "";
    private String account = "";
    private String transfer = "";
    private String params = "";

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Long getCredits() {
        return this.credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, String> toRequestMap(String appSecret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("description", this.description);
        map.put("uid", this.uid);
        map.put("appKey", this.appKey);
        map.put("developBizId", this.developBizId);
        map.put("appSecret", appSecret);
        map.put("timestamp", System.currentTimeMillis() + "");
        map.put("orderNum", this.orderNum);
        map.put("params", this.params);
        this.putIfNotEmpty(map, "transfer", this.transfer);
        this.putIfNotEmpty(map, "account", this.account);
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private void putIfNotEmpty(Map<String, String> map, String key, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        map.put(key, value);
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getDevelopBizId() {
        return this.developBizId;
    }

    public void setDevelopBizId(String developBizId) {
        this.developBizId = developBizId;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getTransfer() {
        return this.transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }
}

