/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.duiba.controller;

import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.credits.sdk.CreditConsumeResult;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.duiba.config.DuibaCreditTool;
import com.pcauto.lib.duiba.pojo.DuibaCreditConsumeRequest;
import com.pcauto.lib.duiba.pojo.DuibaCreditConsumeResponse;
import com.pcauto.lib.duiba.pojo.DuibaCreditNotifyRequest;
import com.pcauto.lib.duiba.service.DuibaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"[\u516c\u7528]\u5151\u5427\u63a5\u53e3"})
public class DuibaController {
    @Autowired
    private DuibaService duibaService;
    @Autowired
    private DuibaCreditTool creditTool;

    @GetMapping(value={"/duiba/mall"})
    @ApiOperation(value="\u83b7\u53d6\u79ef\u5206\u5546\u57ce\u94fe\u63a5", notes="\u83b7\u53d6\u79ef\u5206\u5546\u57ce\u8df3\u8f6c\u94fe\u63a5")
    public GenericResponse<String> mall(HttpServletRequest request, @RequestParam(required=false) String redirect) {
        if (this.duibaService == null) {
            throw new RuntimeException("duibaService must be implements");
        }
        String userId = this.duibaService.getUserId(request);
        if (StringUtils.isEmpty((Object)userId)) {
            throw new RuntimeException("userId empty");
        }
        Long credits = this.duibaService.getCredits(userId);
        return new GenericResponse(1, "OK", (Object)this.creditTool.getLoginFreeUrl(userId, credits, redirect));
    }

    @GetMapping(value={"/duiba/consume"})
    @ApiOperation(value="\u6263\u79ef\u5206", notes="\u6263\u79ef\u5206")
    public CreditConsumeResult consume(HttpServletRequest request) {
        String status;
        if (this.duibaService == null) {
            throw new RuntimeException("duibaService must be implements");
        }
        String errorMessage = "";
        String bizId = "";
        Long credits = 0L;
        try {
            CreditConsumeParams params = this.creditTool.parseCreditConsume(request);
            DuibaCreditConsumeRequest consumeRequest = new DuibaCreditConsumeRequest();
            BeanUtils.copyProperties((Object)params, (Object)consumeRequest);
            DuibaCreditConsumeResponse consumeResponse = this.duibaService.consume(consumeRequest);
            status = consumeResponse.getStatus();
            errorMessage = consumeResponse.getErrorMessage();
            bizId = consumeResponse.getBizId();
            credits = consumeResponse.getCredits();
        }
        catch (Exception e) {
            status = "fail";
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        CreditConsumeResult ccr = new CreditConsumeResult();
        ccr.setStatus(status);
        ccr.setBizId(bizId);
        ccr.setErrorMessage(errorMessage);
        ccr.setCredits(credits.toString());
        return ccr;
    }

    @GetMapping(value={"/duiba/notify"})
    @ApiOperation(value="\u5151\u6362\u7ed3\u679c\u901a\u77e5", notes="\u5151\u6362\u7ed3\u679c\u901a\u77e5")
    public void notify(HttpServletRequest request, HttpServletResponse response) {
        if (this.duibaService == null) {
            throw new RuntimeException("duibaService must be implements");
        }
        try {
            CreditNotifyParams params = this.creditTool.parseCreditNotify(request);
            DuibaCreditNotifyRequest notifyRequest = new DuibaCreditNotifyRequest();
            BeanUtils.copyProperties((Object)params, (Object)notifyRequest);
            boolean result = this.duibaService.notify(notifyRequest);
            response.getWriter().write(result ? "ok" : "fail");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                response.getWriter().write("fail");
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return;
        }
    }
}

