package com.pcauto.lib.duiba.config;

import cn.com.duiba.credits.sdk.CreditTool;

import java.util.HashMap;
import java.util.Map;

/**
 * 兑吧工具
 *
 * @author sam
 * @since 2019/8/26
 */
public class DuibaCreditTool extends CreditTool {

    /**
     * 域名
     */
    private String root;

    public String getRoot() {
        return root;
    }

    public DuibaCreditTool(String appKey, String appSecret, String root) {
        super(appKey, appSecret);
        this.root = root;
    }

    /**
     * 获取免登录链接
     * <p>
     * 文档：http://www.duiba.com.cn/tech_doc_book/server/servers/general_autologin_url_2.html
     *
     * @param userId   用户唯一性标识，对应唯一一个用户且不可变 （用not_login作为uid标记游客用户，详见 游客访问: http://www.duiba.com.cn/tech_doc_book/optional/not_login.html）
     * @param credits  用户积分余额（无积分体系独立活动，积分可以传0）
     * @param vip  用户vip等级 （参考文档：http://www.duiba.com.cn/tech_doc_book/optional/vip_degree.html）
     * @param redirect 登录成功后的重定向地址，可以直达积分商城内的任意页面,如果不带redirect参数，默认跳转到积分商城首页
     * @return
     */
    public String getLoginFreeUrl(String userId, Long credits, Integer vip, String redirect) {
        Map params = new HashMap();
        params.put("uid", userId);
        params.put("credits", credits.toString());
        params.put("vip",vip.toString());
        if (redirect != null) {
            // redirect是目标页面地址，如果要跳转到积分商城指定页面，redirect地址就是目标页面地址
            // 此处请设置成一个外部传进来的参数，方便运营灵活配置
            params.put("redirect", redirect);
        }
        String url = this.buildUrlWithSign(root + "/autoLogin/autologin?", params);
        //此url即为免登录url
        return url;
    }
}
